//
//  libCVEngine.h
//  libCVEngine
//
//  Created by alibaba on 17/5/11.
//  Copyright © 2017年 alibaba. All rights reserved.
//
//  Update: 2018/03/21 解决压后台后因ARKit状态重置导致模型消失问题,以及第一次点击时imu数据无效导致无法跟踪问题
//

#ifndef __libCVEngine_H__
#define __libCVEngine_H__
#include <stdint.h>
#include "PoseData.h"

//ORBSlam Test.
#define MONO_TEST 0
#if MONO_TEST
#include <opencv2/opencv.hpp>
#include "runAllTestCase.h"
#endif

//Track Api Test.
#include "trackAPI.h"
#define TRACK_TEST 0
#if TRACK_TEST
#include <opencv2/opencv.hpp>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************
 *
 * Api for SLAM.
 *
 **************************************************************/
int slam_Init(const char *vocFilePath,
                        const sPhyCamParaIOS phyCam,
                        const sVirtualCamParaIOS virtualCam,
                        const sTrackPicParaIOS trackPic,
                        const eUseModeIOS useMode);

void slam_InstanceRelease();

int slam_GetORBImageWH(int *image_w, int *image_h);

void slam_SetARKitRT(float *rtArray, int flag);

sPoseMatrixIOS slam_trackMonocular(unsigned char *yuvSrc, int w, int h,
                              int sensorArray_len,
                              sSensorItemIOS *sensorArray,
                              const double mTimestamp,
                              const sRenderModelParaIOS mRenderModel);


/***************************************************************
 *
 * YUV image Scale/Trans Api.
 *
 **************************************************************/
uint8_t* scaleYuvData(uint8_t *data, int width, int height, int byteRows,
                      int desWidth, int desHeight, int desByteRows);

int scaleYuvDataWithBuffer(uint8_t* data, int width, int height, int byteRows,
                           uint8_t *desdata, int desWidth, int desHeight, int desByteRows);

uint8_t *NV12ToARGB(uint8_t *data_y, int y_stride, uint8_t *data_uv, int uv_stride, int dst_stride,
                    int width, int height);

//+(int)cropYuvData:(uint8_t*)src_data src_width:(int)src_width src_height:(int)src_height dst_data:(uint8_t*)dst_data crop_x:(int)crop_x crop_y:(int)crop_y  dst_width:(int)dst_width  dst_height:(int)dst_height dst_stride:(int)dst_stride;

#if MONO_TEST
+ (int)Monotum:(const char *)vocPath sequeues:(const char *)sequeuePath;
+ (int)Monotum_Init:(const char *)vocPath;
+ (int)Monotum_TrackYUV:(uint8_t *) gray_buf w:(int) width h:(int) height;

+(void)runTestCase:(const char *) base_dir doc_dir:(const char *) doc_dir;
#endif

/***************************************************************
 *
 * Api for track2D.
 *
 **************************************************************/

/*
 初始化接口:
 input:
 modelPath   :   model.bin文件的路径
 phyCam      :   相机物理参数
 virtualCam  :   相机虚拟参数
 width       :   追踪图片的宽
 height      :   追踪图片的高
 output:
 0           :   初始化成功
 非0         :   初始化失败
 */
int TrackSystemInit(const char *modelPath, const sPhyCamParaIOS phyCam, const sVirtualCamParaIOS virtualCam, int width, int height);

/*
 追踪接口:
 input:
 gray_buff   :   追踪图片的Y通道首地址
 width       :   追踪图片的宽,需与初始化一致
 height      :   追踪图片的高,需与初始化一致
 step        :   追踪图片每行的pitch
 output:
 TrackResult :   追踪结果
 TrackResult.trackOK :   追踪结果
 TrackResult.pose    :   4*4 矩阵,表示相机到图像的RT变换, 在trackOK为true时有意义
 */
TrackResult TrackSystemTrackImage(uint8_t *gray_buf, int width, int height, int step);

/*
 注销接口:
 input:none
 output:
 0           :   注销成功
 */
int TrackSystemUninit();


/***************************************************************
 *
 * Api for Vision APIs using opencv.
 *
 **************************************************************/
/*
 @params img_buf1:  memory buffer1(ARGB format).
 @params img_buf2:  memory buffer2(ARGB format).
 @params img_w:     image width.
 @params img_h:     image height.
 @return value:     < 0.0 mean invalid.
                    > 0.0 mean success.
 */
double SSIM(uint8_t *img_buf1, uint8_t *img_buf2, int img_w, int img_h);

/*
 @params preFrame_buf:  memory buffer1(ARGB format).
 @params curFrame_buf:  memory buffer2(ARGB format).
 @params img_w:     image width.
 @params img_h:     image height.
 @return value:     NULL mean invalid.
                    if not NULL, return value is double[3x3] array.
 */
double* Darkhorse(uint8_t *preFrame_buf, uint8_t *curFrame_buf, int img_w, int img_h);

//
///*
// hog行人检测接口:
// input:
// gray_buf    :   检测图片Y通道地址
// width       :   检测图片的宽
// height      :   检测图片的高
// step        :   检测图片Y通道每行的pitch
// winStrideX  :   x方向步进长度
// winStrideY  :   y方向步进长度
// scale       :   检测缩放尺度
//
// output:
// RectVector         :   检测结果,具体结构请见trackAPI.h
// RectVector.numRect :   矩形框的数量
// RectVector.pRects  :   存有矩形框数组的指针,使用完毕后需进行存释放
//
// */
//+(RectVector)HogDetectMultiScaleGray:(uint8_t *)gray_buf width:(int)width height:(int)height step:(int)step winStrideX:(int)winStrideX winStrideY:(int)winStrideY scale:(double)scale;
///*
// hog行人检测接口:
// input:
// bgra_buf    :   检测图片(memory bgra)指针
// width       :   检测图片的宽
// height      :   检测图片的高
// step        :   检测图片每行的pitch
// winStrideX  :   x方向步进长度
// winStrideY  :   y方向步进长度
// scale       :   检测缩放尺度
//
// output:
// RectVector         :   检测结果,具体结构请见trackAPI.h
// RectVector.numRect :   矩形框的数量
// RectVector.pRects  :   存有矩形框数组的指针,使用完毕后需进行存释放
//
// */
//+(RectVector)HogDetectMultiScaleBGRA:(uint8_t *)bgra_buf width:(int)width height:(int)height step:(int)step winStrideX:(int)winStrideX winStrideY:(int)winStrideY scale:(double)scale;
//

/***************************************************************
 *
 * Api for handTrack
 *
 **************************************************************/

/*
 初始化接口:
 input:
 yuv_buf     :   追踪图片的首地址
 width       :   追踪图片的宽
 height      :   追踪图片的高
 step        :   追踪图片每行的pitch
 rect        :   手的初始化位置
 
 output:
 0           :   初始化成功
 非0         :   初始化失败
 */
int HandTrackerInit(uint8_t *yuv_buf, int width, int height, int step, sRectInfoDataIOS rect);

/*
 追踪接口:
 input:
 yuv_buf     :   追踪图片的首地址
 width       :   追踪图片的宽
 height      :   追踪图片的高
 step        :   追踪图片每行的pitch
 
 output:
 sRectInfoDataIOS           :   追踪结果,只有在sRectInfoDataIOS.isLost时结果有意义
 sRectInfoDataIOS.x         :   boundingbox 左上角 x坐标
 sRectInfoDataIOS.y         :   boundingbox 左上角 y坐标
 sRectInfoDataIOS.width     :   boundingbox 宽
 sRectInfoDataIOS.height    :   boundingbox高
 sRectInfoDataIOS.isLost    :   是否追丢
 */
sRectInfoDataIOS TrackHand(uint8_t* yuv_buf, int width, int height, int step);

/*
 注销接口:
 input:none
 output:
 0           :   注销成功
 */
int handTrackerUninit();
    
#ifdef __cplusplus
}
#endif

#endif  //#ifndef __libCVEngine_H__
