#pragma once

#include <string>
#include <vector>

#ifndef EXPORT
#  define EXPORT __attribute__ ((visibility("default")))
#endif

struct Tensor {
    std::string name;
    std::vector<int> shape;
    std::string type;
    bool reference;
    const void* buffer;
    long long int buffer_size;

    Tensor() {
        name = "";
        std::vector<int>().swap(shape);
        type = "";
        reference = false;
        buffer = nullptr;
        buffer_size = 0;
    }
};

using Tensors = std::vector<Tensor>;

struct Actions {
    std::vector<float> crop;
    std::vector<int> resize;
    int convert = -1;
    int rotate = 0;
    std::vector<int> pad;
    int padValue = 0;
    bool mirror = false;
    bool flip = false;
};
