#pragma once
#include <sys/time.h>
#include "defs.h"

class EXPORT StillImageFilter {
public:
    StillImageFilter() = default;
    ~StillImageFilter() = default;
    
    int initImageStaticFilter(int StillNum=6, float initDelaySecond=0.2, float minIntervalSecond=0.03, float minStillSecond=0.2);
    bool runImageStaticFilter(Image image);
    void releaseImageStaticFilter();

private:
    void setpara(float delaysec=1.0f,float intervalsec=0.3f,float stillsec=2.0f,int stillnum=3);
    void setParaNew(float delaysec,float intervalsec,float stillsec,int stillnum,float simThres,int useNew,int biosin);
    float compThumbnailNew(float *data1, float *data2, int width, int height);
    int  isStillFrame(unsigned char *pimg, int width, int height);
    bool isMoveFast();
    
    void getNormPara(int width, int height);

    float compThumbnail1(float *data1, float *data2, int width, int height);
            
    float compThumbnail(float *data1, float *data2, int width, int height);
    
    bool genThumbnailImage(unsigned char *pdata, int width, int height);
    
    void reset();
    
    
    int still_num;
    int move_num;
    
    int frame_num;
    
    int widthPrev;
    int heightPrev;
    
    int normWidth;
    int normHeight;
    
    float simThreshold;
    
    float *normDataPrev;
    float *normDataCurr;
        
    timeval time_prevprocess;
    timeval time_startcamera;
    
    timeval time_firststill;  //新添加，辅助用时间来判断是否静止
    
    float minIntervalsecond;
    float delaysecond;
    float stillsecond;
    int   minStillNum;
    int useNewCompThumbnail;
    int bios;
    
    float *histwPrev;
    float *histhPrev;
    float *histwCurr;
    float *histhCurr;
};
