#pragma once

#include <memory>
#include <string>
#include <vector>
#include <map>
#include <set>

class SelfRelatedPoseMatcher {
public:
    SelfRelatedPoseMatcher() = default;
    ~SelfRelatedPoseMatcher() = default;

    bool init(std::string txtConfig);
    int match(float *kps, int index);
    void release();

    bool isIndexSupported(int index);

private:
    std::set<int> supportedIndex_;
    std::map<int, std::vector<std::vector<float>>> e_pairs_;
    std::map<int, std::vector<std::vector<float>>> c_pairs_;
};

