#pragma once

#include <string>
#include <vector>

std::vector<float> get_normalised_vec(const float* kps, 
                                        int start, int end);
float cal_cosine_dist(const std::vector<float>& vec1,
                      const std::vector<float>& vec2);
float cal_euclidean_dist(const std::vector<float>& vec1,
                            const std::vector<float>& vec2);

bool apply_thres_euclidean(float val, float mean, float std);
bool apply_thres_cosine(float val, float thres);
std::vector<std::string> split(const std::string& str, const std::string& delim);

bool val_close(float a, float b);
