//
//  live_human_segment_wrapper.hpp
//  XMedia
//
//  Created by david on 2021/8/18.
//  Copyright © 2021 Alipay. All rights reserved.
//


#ifndef live_human_segmentation_wrapper_hpp
#define live_human_segmentation_wrapper_hpp

#include <stdio.h>
#include <string>
#include <vector>
#include <memory>

#ifdef ANDROID
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "tensor_process_wrapper.h"
#include "tensor_utils.h"
#include "face_track_info.h"

#include "defs.h"

class SegOneEuroFilter;


struct LHSSize {
    float width;
    float height;
};

struct LHSFrame {
    float x;
    float y;
    float width;
    float height;
};

struct MultiImageResultInfo : ResultInfo {
    std::vector<Image> rstImages;
};

typedef enum {
    SEGMENTOR_STATUS_SUCCESS = 0,
    SEGMENTOR_STATUS_INVALID_ARGUMENT,
    SEGMENTOR_STATUS_INIT_FAILED,
    SEGMENTOR_STATUS_UNKNOWN = 100
} SEGMENTOR_STATUS;

class EXPORT LiveHumanSegmentationWrapper { //public NNBaseFunctor
public:
    LiveHumanSegmentationWrapper();
    ~LiveHumanSegmentationWrapper() = default;
    
public:
    int init(std::vector<std::string> modelPath, std::string xnnConfig, std::string algoConfig) ;
    std::vector<Image> run(Image input_image, const float roi[], const int rotation, const bool mirror);
    std::vector<Image> run_multi_instance(Image input_image, const std::vector<FaceDetail> face_details, const int rotation, const bool mirror);
    std::vector<Image> process_image(Image & input_image, const float* inputRoi, const int degree, const bool mirror, const int targetIndex);
    Image post_process(float *maskData,const unsigned char *inputBuffer, LHSSize maskSize, LHSFrame roi, SegOneEuroFilter* filter, float* preMaskData, unsigned char* preInputImg);
    std::vector<Image> post_process_multiclass(float *maskData,const unsigned char *inputBuffer, LHSSize maskSize, LHSFrame roi, float* preMaskData);
    void release();
 
    
private:
    void * _processor;          //算法引擎对象
    std::vector<std::string> _modelPaths;
    std::string _xNNConfig;
    std::string _algoConfig;
    int parseAlgoConfig(std::string json);
    int setDefaultAlgoParams();
    double now_sec();
    std::vector<int> _inputTensorSize;
    std::vector<int> _outputTensorSize;

    std::vector<Tensor> _inputTensors;
    std::vector<Tensor> _outputTensors;
    std::vector<float*> _preMaskData;
    std::vector<unsigned char*> _preInputImg;
    std::vector<SegOneEuroFilter*> _filter;
    float _d_cutoff;
    float _min_cutoff;
    float _beta;
    float _bgThres;     //背景阈值
    float _fgThres;     //前景阈值
    int _preMaskMode; //是否开启pre-mask模式
    int _pxlChgThres;
    int _numClass; //语义分割数量
    float _predUpdateTh;
    int _interFrameFusion;//帧间融合后处理
    int _maxNumTarget; //最大处理目标数量
    std::map<int, int> _instance_track_map;// input_index : seg_index

    // uitl funcs
    void clear_init_time_buffer(int seg_index);
    int get_valid_seg_index(const std::vector<int> seg_track_states);
    std::vector<float> get_dilated_bbox(const float H, const float W, const std::vector<float> faceRect, const float dilate_ratio);

};

#endif /* live_human_segment_wrapper_hpp */
