#ifndef HUAMAN_POSE_DETECT_H_
#define HUAMAN_POSE_DETECT_H_

#include <string>
#include <defs.h>
#include "xNN/xnn.hpp"

class HumanPoseDetect 
{
public:
	HumanPoseDetect() = default;
	~HumanPoseDetect() = default;

	int init(std::string model, std::string algo_config, std::string xnn_config);
	const float * run(unsigned char* data, int width, int height);
	void release();

	bool shape(int& width, int& height);


private:
    float * img_in_debug_ = NULL;
	xNN * xNN_engine_ = nullptr;
	void parseAlgoConfig(std::string config);
};

#endif
