#ifndef HUMAN_DETECT_H_
#define HUMAN_DETECT_H_

#include <string>
#include "xNN/xnn.hpp"

class HumanDetection 
{
public:
	HumanDetection() = default;
	~HumanDetection() = default;

	int init(std::string model, std::string algo_config, std::string xnn_config);
	const float* run(unsigned char* data, int width, int height);
	void release();

	bool shape(int& width, int& height);
	int getNumOutputs();
	int predict_first(float &x1, float& y1, float& x2, float&y2, float& score);


private:
	xNN * xNN_engine_ = nullptr;
	void parseAlgoConfig(std::string config);
};

#endif
