//
// Created by yuting on 2021/9/6.
//

#ifndef DYNAMIC_RECOGNITION_WRAPPER_H_
#define  DYNAMIC_RECOGNITION_WRAPPER_H_

#pragma once

#include <string>
#include <vector>
#include <memory>

#include "defs.h"
#define KPT_NUM 14


class DynamicRecognition;
class MultiFrameFusion;

class EXPORT DynamicRecognitionWrapper {
public:
    int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);
    Results run(Image& image, float* data, float roi[], int rotation, bool mirror, float kpt_conf = 1);
    void release();

private:
    void parseAlgoConfig(std::string json);
    Results dynamic_run(float* data, float kpt_conf);
    Result state_machine(float score, std::string state);

private:
    std::shared_ptr<DynamicRecognition> dynamic_recognition_engine_=nullptr;
    std::shared_ptr<MultiFrameFusion> multi_frame_fusion_engine_=nullptr;
    Result smooth(Result& result);
    float* template_feature_=nullptr; 

    // dynamic paramerter
    Result smooth_result;
    int empty_threshold_ = 10;
    int last_threshold_ = 1;
    int start_frame_threshold_ = 5;
    int stride_ = 2;
    int window_stride_ = 2;
    int window_skip_stride_ = 5;
    int camera_index_ = 0;
    int cnt_empty_ = 0;
    int cnt_last_ = 0;
    int cnt_valid_ = 0; 
    float smooth_max_score = 0;
    int smooth_time = 0;
    int smooth_ = 1;
    std::string smooth_label = "14Others";

    // static paramerter
    int feature_dims_ = 256; 
    int template_nums_ = 2;
    // state machine
    float enter_thre_ = 70;
    float exit_thre_ = 70;
    int state1_rep_thre_ = 1;
    int state2_rep_thre_ = 1;
    int s1_repeats_ = 0;
    int s2_repeats_ = 0;
    int s1_score_ = 0;
    int s2_score_ = 0;
    int _pose_entered = 0;
    int count_ = 0;

    // static or dynamic modula
    int is_static_ = 1;
    float * data_ = nullptr;
    int kpts_num_;
};

#endif



