#pragma once

#include <memory>
#include <deque>
#include <set>

class DynamicPoseMatcher {
public:
    DynamicPoseMatcher() = default;
    ~DynamicPoseMatcher() = default;

    bool init(int fps);
    int match(float *kps, int index);
    void release();

    bool isIndexSupported(int index);

private:
    float get_kps_y(float* kps, int kp_idx);
    int check_deltas(const std::deque<float>& dq);

    int buffer_size_;
    std::set<int> supportedIndex_;
    std::deque<float> history_angles_;
    std::deque<float> history_rightElbow_y_;
    std::deque<float> history_leftElbow_y_;
};

