#pragma once

#include <string>
#include <vector>
#include <memory>
#include <map>
#include "defs.h"
#include "common_key_frame_wrapper.h"
#include "common_detect_classification_wrapper.h"
#include "classify.h"
#include "ocr_wrapper.h"

struct keyFrameConfig {
    float threshold = 0.49;
    int histSize = 32;
    int range[2] = {0,256};
    int gap = 8;
    int maxKeyNum = 1;
    float summaryLen = 0;
    int mode = 0;
    int format = 3;
};

//struct KeyFrameResult {
//    unsigned char *keyFrame = nullptr;
//    bool thumbnail = false;
//    Results keyFrameInfo;
//    std::string keyFrameInfoStr;
//    std::string videoInfoStr;
//    Results videoInfo;
//};

struct KeyFrameResult {
    unsigned char *keyFrame = nullptr;
    std::map<std::string, std::string> keyFrameInfo;

};
struct VideoResult {
    std::map<std::string, std::string> videoInfo;
};

class  CommonImageComprehendWrapper {
public:
    CommonImageComprehendWrapper()=default;
    ~CommonImageComprehendWrapper();
    int init(std::vector<std::string> modelPath, keyFrameConfig config, std::string xnnConfig, bool thumbMode, bool isEdit);
    void processImage(unsigned char *image, int width, int height,  double timeStamp, bool finalFrame); //算法入口函数
    float getUseTime(); //获取算法处理每帧耗时
    std::vector<KeyFrameResult> getKeyFrameResults(); //获取关键帧相关结果
    VideoResult getVideoResults(); //获取视频标签结果
    
private:
    void comprehendImage(unsigned char* image, int height, int width, int format, std::string key, KeyFrameResult &keyFrameResult); 
    void ocrDetect(unsigned char *image, int height, int width, int format, bool &hasChacter);
    void mergeInfo(std::vector<bool> characterInfo, bool isEdit, std::vector<KeyFrameResult> &keyFrameResults);
    void rgba2rgb(unsigned char *rgba, int height, int width, unsigned char *rgb);
    void comprehendVideo(std::vector<unsigned char *> inputData, int height, int width, int format, std::string key, VideoResult &videoResults);

    
private:
    CommonKeyFrameWrapper *_keyFrameWrapper;
    CommonDetectClassificationWrapper *_commonNNWrapper;
    CommonDetectClassificationWrapper *_commonNNWrapperVideo;
    std::shared_ptr<OCR> ocr_;
    std::vector<KeyFrameResult> _keyFrameResults;  //关键帧数据及信息
    VideoResult _videoResults;     //视频标签信息
    std::vector<Results> _keyFrameStructResults; //关键帧标签结构化信息，用于封面选择
    bool _thumbMode;       //是否进行封面选择
    int _algoMode;         //算法模式
    int _format;         //输入的数据格式
    bool _isEdit;       //视频是从相册加载或被用户编辑过则为true,否则为false，目前没打开该开关，设为false
    float _timeUsed;    //算法处理每一帧的耗时
};
