#pragma once

#include <string>
#include <vector>
#include <memory>

#include "defs.h"

class CommonDetectClassification;

class EXPORT CommonDetectClassificationWrapper {
public:
    int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);
    Results run(Image image, float roi[], int rotation, bool mirror);
    Results run(const float *data, int width, int height);
    Results runSingleFrame(Image image, float roi[], int rotation, bool mirror);
    Results runMultiFrame(std::vector<Image> images, float roi[], int rotation, bool mirror);
    Results runMultiFrameCommon(Image image, float roi[], int rotation, bool mirror, bool terminate);
    void release();

    Image get_roi_image() {
        return roi_image_;
    }
    
    void set_object_flag(int flag) {
        object_flag_ = flag;
    }
    Image get_object_image() {
        return object_image_;
    }
    
    std::string get_results_json();

private:
    Image roi_image_; // uniform scale to detect image size
    Image roi_image_resize; 
    std::vector<Image> images_;
    std::shared_ptr<CommonDetectClassification> detect_engine_;
    int object_flag_ = 0;
    Image object_image_;
};
