//
//  XMediaSTAResult.h
//  XMedia
//
//  Created by tao zeng on 2020/7/23.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import "XMediaResult.h"

extern NSString *const kXMediaSTAResultNodeInfo;

extern NSString *const kXMediaSTAResultKeyFrameCount;
extern NSString *const kXMediaSTAResultNodeName;
extern NSString *const kXMediaSTAResultKeyTimes;
extern NSString *const kXMediaSTAResultKeyValues;

@interface XMediaAnimationNode : NSObject
@property (nonatomic, assign) int keyFrameCount;
@property (nonatomic, strong) NSString *nodeName;
@property (nonatomic, strong) NSArray *keyTimes;
@property (nonatomic, strong) NSArray *keyValues;

- (instancetype)initWithNodeDict:(NSDictionary *)nodeDict;

@end

@interface XMediaSTAResult : XMediaResult
@property (nonatomic, strong) NSArray<XMediaAnimationNode *> *animationNodes;

- (instancetype)initWithAnimationDict:(NSDictionary *)animationDict;

@end
