//
//  XMediaModelProcesor.h
//  XMedia
//
//  Created by haoxing on 2020/3/19.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@class XMediaModelProcessResult;

@interface XMediaModelProcessor : NSObject

@property (nonatomic, strong, readonly) NSString *processId;

/**
 *  模型加载
 *
 *  @param bizId   业务id
 *  @param modelPath 模型本地地址
 *
 *  @return 返回结果：包含：1：processId；2：input/output tensor中shape，name
*/
- (XMediaModelProcessResult *)modelLoadWithBizId:(NSString *)bizId
                                       modelPath:(NSString *)modelPath
                                         options:(NSDictionary *)options;

- (XMediaModelProcessResult *)getModelProcessResultWithBizId:(NSString *)bizId modelPath:(NSString *)modelPath;

/**
 *  模型处理
 *
 *  @param processId 模型加载返回的处理id
 *  @param inputTensors 需要处理的tensors
 *  @param outputTensors 需要输出的tensors ，目前xNN只支持给出所有输出，所以此参数可以填nil
 *
 *  @return 处理的结果
*/
- (XMediaModelProcessResult *)modelInferWithProcessId:(NSString *)processId
                                         inputTensors:(NSArray *)inputTensors
                                        outputTensors:(NSArray *)outputTensors
                                              options:(NSDictionary *)options;

@end
