//
//  XMediaKeyFrameConfig.h
//  XMedia
//
//  Created by tao zeng on 2021/3/1.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface XMediaKeyFrameConfig : NSObject
@property (nonatomic, assign) float threshold;          //关键帧检测阈值
@property (nonatomic, assign) int histSize;             //直方图的 bin数量
@property (nonatomic, strong) NSArray *rangeArray;      //直方图的统计像素值范围
@property (nonatomic, assign) int gap;                  //图像采样间隔
@property (nonatomic, assign) int maxKeyNum;            //关键帧的最大数量
@property (nonatomic, assign) float summaryLen;         //视频摘要的长度
//默认0:正常模式(关键帧+端标签算法)，1:降级模式(只走 端标签算法), 2:降级模式(不走算法，只返回图片结果)
@property (nonatomic, assign) int mode;
@end

NS_ASSUME_NONNULL_END
