//
//  XMediaJSONExtensions.h
//  XMedia
//
//  Created by tao zeng on 2018/9/30.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface NSObject (APMJSONKitExtensions)

/**
 *  将NSObject序列化成字符串。
 *
 *  @return 序列化成字符串.
 */
- (NSString *)APMJSONString;

@end

@interface NSString (APMJSONKitExtensions)

/**
 *  将字符串反序列化成NSObject对象。
 *
 *  @return 反序列化NSObject对象。
 */
- (id)APMJSONValue;

@end

@interface NSData (APMJSONKitExtensions)

/**
 *  将Data反序列化成NSObject对象。
 *  Data应该应该是utf8编码的json字符串。
 *
 *  @return 反序列化NSObject对象。
 */
- (id)APMJSONValue;

@end

NS_ASSUME_NONNULL_END
