//
//  XMediaCloudConfig.h
//  XMedia
//
//  Created by tao zeng on 2018/7/25.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface XMediaCloudConfig : NSObject

//xNN 云控配置
+ (NSString *)getXNNConfig;

//人体姿态检测功能是否支持
+ (BOOL)getPoseDetectSupport;
//微笑检测功能是否支持
+ (BOOL)getSmileDetectSupport;
//手势检测功能是否支持
+ (BOOL)getGestureDetectSupport;
//手势置信度阈值
+ (NSDictionary *)getGestureThreshold;

//微笑检测实现一次算法，时间最小步长
+ (float)getSmileDetectTime;
//手势检测实现一次算法，时间最小步长
+ (float)getGestureDetectTime;

//人体姿态检测配置
+ (NSDictionary *)getPoseDetectConfig;

//AR平台图像识别开关
+ (BOOL)isFalconAREnable;

//人脸识别兼容性开关
+ (BOOL)isFaceEnable;

//AR平台本地识别兼容性开关
+ (BOOL)isSurfFreakEnable;

//判断机型是否支持接口
//configDict 机型描述json
+ (BOOL)isDeviceSupportWithConfig:(NSDictionary *)configDict;

//获取算法自适应相关云控配置
+ (NSDictionary *)getAlgoAdaptiveConfig;

//预发functor 释放xnnShareModel 开关, 默认:YES
+ (BOOL)shouldXNNShareModelRelease;

//是否使用新版人脸检测/跟踪引擎
+ (BOOL)shouldUseNewFaceTrackEngine;

@end
