//
//  XMediaASRFunctor.h
//  XMedia
//
//  Created by lwj on 2022/3/2.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import "XMediaBaseFunctor.h"

NS_ASSUME_NONNULL_BEGIN

@interface XMediaAsrFunctorResult : NSObject

@property (nonatomic, strong) NSString *result; //识别结果
@property (nonatomic, strong) NSString *codeVersion;
@property (nonatomic, strong) NSString *configVersion;

@property (nonatomic, assign) CGFloat probability; //可信度
@property (nonatomic, assign) int predict;
@property (nonatomic, assign) int callbackStatus;  //是否要回调.1,是;0,否

@end


@interface XMediaASRFunctor : XMediaBaseFunctor

@property (nonatomic, strong, readonly) NSString *sessionId;


/**
 *  XMediaKeyPointsFunctor初始化
 *
 *  @param bizId 业务标识
 *  @param modelId 模型文件id
 *  @param modelPaths 模型路径数组
 *  @param options 扩展字段,@{kXMediaRemoteLogSampling:@(0)}
 */
- (instancetype)initWithBizId:(NSString *)bizId
                      modelId:(NSString *)modelId
                    modelPath:(NSString *)modelPath
                      options:(NSDictionary *)options;


/// 识别数据
/// @param audFrame 待识别的音频数据
/// @param isLast 是否为最后一帧.如果是最后一帧,audframe可为空
- (int)appendAudioData:(nullable NSData *)audFrame isLast:(BOOL)isLast;


/// 同步获取结果. 在appendAudioData之后获取结果.
- (XMediaAsrFunctorResult *)getResult;

// 目前只是简单生成一个sessionId,这个用来标识.
- (NSString *)start;

//调用算法的reset
- (void)stop;

@end

NS_ASSUME_NONNULL_END
