//
//  TinyTrackerLog.h
//  TinyTracker
//
//  Created by LiMengtian on 2019/6/24.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TinyTrackerLog : NSObject

#pragma mark - 页面埋点

/**
 *  pageMonitor，页面打开
 *
 *  @param tinySeedId 代表当前小程序的ID
 *  @param view 埋点对应view，传vc对象最好，其次view对象，不能为空
 *
 */
+ (void)onPageStartWithTinySeedId:(NSString *)tinySeedId
                             view:(nonnull NSObject *)view;

/**
 *  pageMonitor，页面结束
 *  @param tinySeedId 代表当前小程序的ID
 *  @param view 埋点对应view，传vc对象最好，其次view对象，不能为空
 *  @param bizCode 业务bizCode
 *  @param param 手动埋点扩展参数4，底层保留key不要使用：chInfo
 */
+ (void)onPageEndWithTinySeedId:(NSString *)tinySeedId
                           view:(nonnull NSObject *)view
                        bizCode:(NSString *)bizCode
                          param:(NSDictionary *)param;

#pragma mark - 全引导

/**
 *  设置页面参数
 *  @param params 页面参数 {$chinfo, $scm}
 *  @param view 页面
 *  @param step 透传步数，支持【3-5】，最少透传到p-pre2，最多透传到p-pre4
 *  @param isForce 是否强制更新
 */
+ (void)setPageParams:(NSDictionary *)params
              forView:(NSObject *)view
            traceStep:(NSUInteger)step
              isForce:(BOOL)isForce;

@end

NS_ASSUME_NONNULL_END
