//
//  TEXTransformFunctor.h
//  Texel
//
//  Created by feihu on 2019/5/6.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Texel/Texel.h>

// 用于对默认的顶点、片段着色器中的变量进行变换，以完成各种变换效果，如四分屏、右下角显示等
@interface TEXTransformFunctor : TEXFunctor

/**
 *  初始化
 *  两个入参均为方法的实体部分，第一个参数作用于顶点着色器：
 *  @code
    attribute vec4 position;
    attribute vec4 inputTextureCoordinate;
    varying vec2 textureCoordinate;
    precision mediump float;
 
    vec4 transformPosition(vec4 pos) {
        // return pos;
    }
 
    void main() {
        gl_Position = transformPosition(position);
        textureCoordinate = inputTextureCoordinate.xy;
    }
 *  @endcode
 *  默认的方法直接在transformPosition方法中返回pos即可，但该functor允许修改这部分，将方法的实体部分写进
 *  字符串中，如要实现将画面填充右上角的位置，其它部分黑色，可以将第一个参数设置为：
 *  @"return vec4(pos.xy / 2.0 + 0.5, 0.0, 1.0);"
 *
 *  第二个参数作用于片段着色器：
 *  @code
    varying highp vec2 textureCoordinate;
    uniform sampler2D inputImageTexture;
    precision mediump float;
 
    vec2 transformTextureCoordinate(vec2 coord) {
        return coord;
    }
 
    void main() {
        vec2 t = transformTextureCoordinate(textureCoordinate);
        gl_FragColor = texture2D(inputImageTexture, t);
    }
 *  @endcode
 *  默认的方法直接在transformTextureCoordinate方法中返回coord即可，但该functor允许修改这部分，将方法的实体部分写进
 *  字符串中，如要实现四分屏，每个部分都完全一样，可以将第二个参数设置为：
 *  @"return fract(coord.xy * 2.0);"
 *  如果参数为空的话，与默认的着色器一致
 *
 *  @param positionFunctionString 顶点变换的方法
 *  @param coordFunctionString    uv变换的方法
 *
 *  @return 返回创建的functor对象
 */
- (instancetype)initWithPositionFunctionString:(NSString *)positionFunctionString
                           coordFunctionString:(NSString *)coordFunctionString NS_DESIGNATED_INITIALIZER;

@end
