//
//  TEXRawDataOutput.h
//  Texel
//
//  Created by feihu on 2019/6/7.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "TEXOutput.h"

@class TEXRawDataOutput;
@protocol TEXRawDataOutputDelegate <NSObject>
// 有数据更新，可以在这个回调中调用getCurrentFrame的方法来获取当前帧
- (void)rawDataOutputDidReceiveNewFrame:(TEXRawDataOutput *)rawDataOutput;
@end

// 输出当前GPU中渲染的帧数据，格式为RGBA
@interface TEXRawDataOutput : NSObject <TEXInput>
@property (nonatomic, weak) id<TEXRawDataOutputDelegate> delegate;
@property (nonatomic, assign) CGSize inputSize;

// 大小不能够超过设备的最大范围，如果超过时，会被裁减至适合的尺寸。
// 如果业务需要关心可能会被裁剪至什么尺寸，可以调用
// +[TEXContext sizeThatFitsWithinATextureForSize:]查询
@property (nonatomic, assign) CGSize outputSize;

/**
 *  输出数据方向是否是OpenGL坐标系，默认为NO，采用的是图像坐标系，会上下翻转，原点在左上角；
 *  如果设置成YES，则采用OpenGL坐标系，使原点在左下角
 */
@property (nonatomic, assign) BOOL useOpenGLCoordinatesSystem;

@property (nonatomic, strong) TEXContext *context;

// 数据类型为GLubyte，长度为inputSize.width * inputSize.height * 4 * sizeof(GLubyte)，格式为RGBA
- (NSData *)getCurrentFrame;

@end
