//
//  TEXMicSource.h
//  Texel
//
//  Created by Cloud on 2017/6/7.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "TEXSource.h"

@class TEXMicSource;
@protocol TEXMicSourceDelegate <NSObject>
- (void)micSource:(TEXMicSource *)micSource didOutputWithSampleBuffer:(CMSampleBufferRef)sampleBuffer;
@end

@interface TEXMicSource : TEXSource
@property (nonatomic, weak) id<TEXMicSourceDelegate> delegate;
@property (nonatomic, assign, readonly) AudioStreamBasicDescription format;
@property (nonatomic, assign) BOOL enableEchoCancellation; // 回声消除，必须在setup之前设置有效。默认为NO

- (BOOL)setupWithSampleRate:(int)sampleRate;
- (BOOL)finish;

+ (NSData *)pcmDataFromSampleBuffer:(CMSampleBufferRef)sampleBuffer;

@end
