//
//  TEXCameraView.h
//  Texel
//
//  Created by feihu on 2018/3/12.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <APMUtils/APMCameraView.h>
#import "TEXFunctor.h"
#import "TEXSource.h"

typedef NS_OPTIONS(NSUInteger, TEXTakePictureOptions) {
    TEXTakePictureSilence = (1UL << 0), // 静音拍摄，如果original打开，无效
    TEXTakePictureOriginal = (1UL << 1), // 拍摄原始图片，不经过filter的处理。如果preset是Photo是，将拿到高清图片
    // 保持长宽比，最终将得到的图像处理成view的长宽比
    // 如果useDeviceOrientation是YES，是竖着拍摄时，与view长宽比一致
    // 如果是横向时，view的长宽比需要交换长宽
    TEXTakePicturePreserveAspectRatio = (1UL << 2),
    // 缩放至最短边，如果设置了shortSide，则以shortSide为为准 ;
    // 否则保持preset的最短边设置，如preset设置的是720x1280，如果上面的保持长宽比打开，
    // 对于2:1的view，可能会被裁剪成720x360。但设置了该option后，会保持最短边720，
    // 因此得到1440x720，在设置了aspectRatio的option后才有效
    TEXTakePicturePreservePresetShortSide = (1UL << 3)
};

/**
 *  拍摄照片Block
 *
 *  @param image   拍得的照片
 *  @param error   异常信息
 */
typedef void (^TEXTakePictureHandler)(UIImage *image, NSError* error);

@interface TEXCameraView : APMCameraView
@property (nonatomic, strong) TEXFunctor *filter;
@property (nonatomic, strong, readonly) TEXSource *source; // 可用于录制的源，添加给TEXRecorder，包含了filter的处理
@property (nonatomic, assign) BOOL silence; // 拍照时是否静音，默认为NO
// 拍照时的最短边，当TEXTakePicturePreservePresetShortSide设置时有效
// 默认未设置，与相机流中获取的图像最短边保持一致。当设置该值时，使用该值
@property (nonatomic, assign) int shortSide;

/**
 *  扩展的拍摄照片接口
 *
 *  @param  handler     拍摄照片完成回调，回调位于主线程
 *  @param  options     拍摄照片的参数配置
 */
- (void)takePicture:(TEXTakePictureHandler)handler options:(TEXTakePictureOptions)options;

@end
