//
//  APMediaFileSecAnalyzer.h
//  SecFw
//
//  Created by Payne Lee on 2019/6/26.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, SecFwErrorCode) {
    SecFwErrorCodeDowngrade = 1001, // 已降级
    SecFwErrorCodeInitRuleFail = 1002, // 解析规则失败
};

@interface APMediaFileSecAnalyzer : NSObject

/**
 * @param rules 检测规则,JSON字符串
 */
- (instancetype)initWithRules:(NSString *)jsonRules error:(NSError **)error;

/**
 * @param filePath 多媒体文件路径
 * @param extraDictionary 字典
 * @return YES: 安全；NO: 有风险；
 */
- (BOOL)checkMediaFile:(NSString *)filePath extraInfo:(NSDictionary *)extraDictionary error:(NSError **)error;

@end

NS_ASSUME_NONNULL_END
