//
//  SPMBehaviorLogger.h
//  SPMTracker
//
//  Created by LiMengtian on 2019/9/2.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SPMTracker/SPMBehaviorBuilder.h>

// 参考文档 https://yuque.antfin-inc.com/dc/guide/ios_dev_new

NS_ASSUME_NONNULL_BEGIN

@interface SPMBehaviorLogger : NSObject

#pragma mark - log

/// 点击
+ (void)click:(SPMBehaviorBuilder *)behaviorBuilder DEPRECATED_MSG_ATTRIBUTE("手动埋点已废弃，请使用UEP");
/// 曝光
+ (void)exposure:(SPMBehaviorBuilder *)behaviorBuilder DEPRECATED_MSG_ATTRIBUTE("手动埋点已废弃，请使用UEP");

/// 页面埋点 （一次页面埋点的调用 由 一次到多次页面开始 一次页面结束 一次页面销毁 三部分组成）
+ (void)pageStart:(SPMBehaviorBuilder *)behaviorBuilder;
+ (void)pageEnd:(SPMBehaviorBuilder *)behaviorBuilder;
+ (void)pageDestory:(SPMBehaviorBuilder *)behaviorBuilder;


@end

NS_ASSUME_NONNULL_END
