//
//  SPMBehaviorLogger+Internal.h
//  SPMTracker
//
//  Created by LiMengtian on 2020/1/3.
//  Copyright © 2020 Alipay. All rights reserved.
//

#ifndef SPMBehaviorLogger_Internal_h
#define SPMBehaviorLogger_Internal_h

#import <SPMTracker/SPMBehaviorLogger.h>
#import <SPMTracker/SPMBehaviorBuilder+Internal.h>

NS_ASSUME_NONNULL_BEGIN

@interface SPMBehaviorLogger()

//设置页面公共参数
//构造builder需要填写 view属性 和 commonParams属性
+ (void)setPageComomParams:(SPMBehaviorBuilder *)behaviorBuilder;

@end

@interface SPMBehaviorLogger (Nebulalogging)

/**
*  容器 点击和曝光 行为埋点专用  其他业务不要用
*
*  @param actionId  action ID APMonitorPointDataDefines.h 只能填 kActionID_Clicked 或者 KActionID_Exposure
*  @param extParams 可选，扩展参数，业务自己根据需要填充。数组元素最多5个，第四个和第五个元素可以是字典
*  @param appId     可选，子应用ID
*  @param seed      可选，埋点ID，现已更名为spm，若有则务必填写。
*  @param ucId      可选，用例编号
*  @param bizType   业务类型. 默认值为behavior,若传入非空的自定义的bizType，请务必保证已经跟mdap服务端申请了该bizType,否则服务端会丢弃该日志
*  @param logData jsapi 业务原始入参
*  @param view 页面标识对象
*  @param formatterDictionary  可选，业务可以根据需求自定义formatter字典值，内容ID(entityId/SCM)、日志头(header)、页面Id(pageId)、日志级别(logLevel)、ABTest实验信息(abTestInfo)可通过该字段自定义。
*/
+ (void)nebulaWriteLogWithActionId:(NSString *)actionId
                         extParams:(nullable NSArray *)extParams
                             appId:(nullable NSString *)appId
                              seed:(NSString *)seed
                              ucId:(nullable NSString *)ucId
                           bizType:(NSString *)bizType
                           logData:(NSDictionary *)logData
                              view:(NSObject *)view
               formatterDictionary:(nullable NSDictionary *)formatterDictionary;

@end

NS_ASSUME_NONNULL_END

#endif /* SPMBehaviorLogger_Internal_h */
