//
//  SPMBehaviorBuilder.h
//  SPMTracker
//
//  Created by LiMengtian on 2019/9/2.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APRemoteLogging/APMonitorPointDataDefines.h>

// 参考文档 https://yuque.antfin-inc.com/dc/guide/ios_dev_new

NS_ASSUME_NONNULL_BEGIN

@interface SPMExposureItem : NSObject

- (instancetype)initWithSpm:(NSString *)spm
                        scm:(NSString *)scm;
@end

////////////////////////////////////////////////////////////////////////////////

@interface SPMBehaviorBuilder : NSObject <NSCopying>

#pragma mark - property

#pragma mark - 必填值
@property (nonatomic, copy) NSString *spmId;
@property (nonatomic, copy) NSString *bizCode;
// view 和 pageId 二选一，至少有一个合法，优先级view > pageId
@property (nonatomic, strong) NSObject *view;
@property (nonatomic, copy) NSString *pageId;
#pragma mark - 选填
@property (nonatomic, copy) NSString *entityId;
//流量位scm，chinfo 仅点击和曝光设置有效
@property (nonatomic, copy) NSString *scm;
@property (nonatomic, copy) NSString *nChinfo;
@property (nonatomic, copy) NSDictionary *param4;
@property (nonatomic, copy) NSString *logLevel;
@property (nonatomic, copy) NSString *appId;
@property (nonatomic, copy) NSString *ucId; //用例ID，被弃用了，为了兼容老埋点升级
@property (nonatomic, assign) SPMPageType pageType;
@property (nonatomic, assign) BOOL fromUep;
@property (nonatomic, copy) NSString *clickSeq;
@property (nonatomic, copy) NSString *pageSeq;
@property (nonatomic, copy) NSDictionary *uepParams5;
@property (nonatomic, copy) NSString *xpath;
#pragma mark - 开关
//是否开启点击透传 仅点击有效 
@property (nonatomic, assign) BOOL isTrace;
//是否开启渠道链透传 仅点击有效
@property (nonatomic, assign) BOOL isChainEnable;
//是否开启透传页面公共参数
@property (nonatomic, assign) BOOL isCommonParamsEnable;
//uep切换是否串联过滤
@property (nonatomic, assign) BOOL disableSpmContact;
#pragma mark - Helper

- (void)appendExposureItem:(SPMExposureItem *)item;
- (void)appendExposureItemList:(NSArray<SPMExposureItem *> *)list;

@end

NS_ASSUME_NONNULL_END
