//
//  TAAuthorizeStorageManager.h
//  TinyappService
//
//  Created by 闻蹊 on 2018/3/30.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

// ------------------------- 权限类型 -------------------------------------
#define TA_CAMERA   @"相机"
#define TA_LBS      @"当前位置"
#define TA_ALBUM    @"相册"
#define TA_MIC      @"麦克风"
#define TA_USER     @"用户信息"
#define TA_SENDMTOP @"淘宝账户信息"
#define TA_CONTACT  @"通讯录"
#define TA_AUTHORIZE_ALERT_REMAIN_COUNT     @"AUTHORIZE_ALERT_REMAIN_COUNT"
#define kTAExpandoAuthorizeState @"kTAExpandoAuthorizeState"

typedef NS_ENUM(NSUInteger, TAPermissionState) {
    TAPermissionStateWaiting = 0,
    TAPermissionStateDenied = 1,
    TAPermissionStateApproved = 2
};

static NSString * TA_PERMISSION_KEY_LOCATION       = @"location";
static NSString * TA_PERMISSION_KEY_AUDIORECORD    = @"audioRecord";
static NSString * TA_PERMISSION_KEY_ALBUM          = @"album";
static NSString * TA_PERMISSION_KEY_CAMERA         = @"camera";
static NSString * TA_PERMISSION_KEY_USERINFO       = @"userInfo";
static NSString * TA_PERMISSION_KEY_SENDMTOP       = @"sendMtopPermission";
static NSString * TA_PERMISSION_KEY_CONTACT        = @"contact";

@protocol MPNebulaAdapterInterfaceAuthorizeAlert <NSObject>

/**
 *  自定义授权弹框
 *
 *  @param title 授权信息，由小程序名称与授权类型组合而成，如 "小程序示例"想使用您的相机、相册
 *  @param appName 小程序名称，如"小程序示例"
 *  @param storageKey 需要授权的权限类型，以|拼接的字符串，如 @"album|camera"
 *  @param callback 用户授权的回调。注意，不允许请返回0，允许返回1
 */
- (void)showAlertWithTitle:(NSString *)title appName:(NSString *)appName storageKey:(NSString *)storageKey callback:(void (^)(NSInteger index))callback;

//
/**
 *  检查当前 jsapi 是否可执行，用于JSAPI管控统计和页面路径 (每次都回调)，
 *  需要配合 开关 nebulaCustomConfig 函数里边 tiny_shouldCheckJsapiPermission key 返回@"YES" 才生效
 *
 *  @param title 小程序名称
 *  @param appId 小程序id
 *  @param page 小程序当前页面路径
 *  @param action 具体的 jsapi
 *  @param scope 安卓字段，iOS 始终为空
 *  @param permissions 需要授权的权限类型，如 @[@"album", @"camera"]
 *  @param callback 用户授权的回调。注意，不允许请返回0，允许返回1
 */
- (void)checkPermissionWithTitle:(NSString *)title
                           appId:(NSString *)appId
                        withPage:(NSString *)page
                      withAction:(NSString *)action
                           scope:(NSString *)scope
                     permissions:(NSArray<NSString *>*)permissions
                        callback:(void (^)(NSInteger index))callback;

@end

@interface TAAuthorizeStorageManager : NSObject
/// key action 字典，用来做自定义权限判断
@property (nonatomic, strong) NSDictionary* mPaaS_customKeyActionDict;
@property(nonatomic, weak) id<MPNebulaAdapterInterfaceAuthorizeAlert> authorizeAlertDelegate; // 授权弹框delegate

+ (instancetype)shareInstance;

/**
 *  获取appid对应小程序已经请求过的权限字典。
 *
 *  @return 权限状态字典
 */
- (NSMutableDictionary *)authStatusDic4AppId:(NSString *)appid;

/**
 *  appid对应小程序该请求权限的结果
 *
 *  @return “0” : 不允许 ， “1” : 允许 , nil则还授权
 */
- (NSString *)authStatus4StorageKey:(NSString *)storageKey appId:(NSString *)appid;


/**
 *  更新小程序对应jsApi权限状态。
 *
 */
- (void)setStatus:(NSString *)status storageKeyArray:(NSArray *)storageKeyArray appId:(NSString *)appid;


/**
 * 删除小程序对应所有权限信息
 **/
- (void)removeAuthInfo4AppId:(NSString *)appid;

/**
 *  jsApi对应的名称。
 *
 *  @return 授权项目名称
 */
- (NSString *)authItemName4StorageKey:(NSString *)key;

- (NSString *)authMessage4StorageKeyList:(NSArray *)storageKeyArr tinyAppName:(NSString *)name;

- (NSString *)helpMessage4StorageKeyList:(NSArray *)storageKeyArr tinyAppName:(NSString *)name;

/**
 * 当前剩余提醒次数
 **/
- (NSUInteger)remainAlertCount;

/**
 * 更新剩余提醒次数
 **/
- (void)storeRemainAlertCount:(NSUInteger)count;


/**
 *  判断jsApi是否在支持权限列表。
 *
 *  @return 如果已支持返回为key值项， 反则为nil
 */
- (NSString *)storageKey4JsApi:(NSString *)storageKey sourceTypes:(NSArray *)sourceTypes;

/**
 *  未请求用户权限storagekey列表
 *  @param storagekey： api映射的存储的key(可能存在 "album|camera")
 *  @param appId：  小程序标识
 *  @return  未请求权限的storagekey列表
 */
- (NSArray *)notAuthList4StorageKey:(NSString *)storagekey appId:(NSString *)appId;

/**
 *  用户拒绝权限的storagekey列表
 *  @param storagekey： api映射的存储的key(可能存在 "album|camera")
 *  @param appId：  小程序标识
 *  @return  用户拒绝权限的storagekey列表
 */
- (NSArray *)rejectedAuthList4StorageKey:(NSString *)storagekey appId:(NSString *)appId;


- (void)showAlertWithTitle:(NSString *)title cancel:(NSString *)cancel confirm:(NSString *)confirm callback:(void (^)(NSInteger index))callback;

/*
 WebAR 访问相机权限管控
 */
- (void)tinyAppAuthorizeWACamera:(NSDictionary *)info callBack:(void(^)(BOOL retCode))callback;

@end
