//
//  NXRUtils.h
//  NebulaResource
//
//  Created by chenwenhong on 15/9/16.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverResource/RVRDefine.h>
@class NXRApp;
/******************************* Encode & Decode **********************************/

NSString *NXRMD5OfString(NSString *string);

NSString *NXRMD5OfData(NSData *data);

NSString *NXRBase64Encode(NSData *data);

NSData *NXRBase64Decode(NSString *string);

NSString *NXRMimeType(NSString *pathExtension);

/******************************** NSDate ******************************************/

NSString *NXRDateString(NSDate *date);

/******************************** NSString ****************************************/

NSString *NXRString(NSString *str, NSString *defaultValue);

/******************************** NSArray *****************************************/

NSArray *NXRArray(NSArray *arr, NSArray *defaultValue);

/******************************** NSDictionary ************************************/

NSDictionary *NXRDict(NSDictionary *dict, NSDictionary *defaultValue);

NSMutableDictionary *NXRMutableDict(NSDictionary *dictionary);

NSMutableArray *NXRMutableArray(NSArray *array);

CGFloat NXRFloatValue(id obj, CGFloat defaultValue);

int NXRIntValue(id obj, int defaultValue);

NSInteger NXRIntegerValue(id obj, NSInteger defaultValue);

BOOL NXRBoolValue(id obj, BOOL defaultValue);

double NXRDoubleValue(id obj, double defaultValue);

NSData *NXRData(NSData *data);

/******************************** Transfer ************************************/

NSString *NXRJsonObjToString(id object);
NSData *NXRJsonObjToData(id object);
id NXRDataToJsonObj(NSData *data);

/******************************** Other *******************************************/
void NXRLog(NSString *logId, NSDictionary *params);

NSString *NXREnvironmentName(const NSInteger environment);

NSString *NXRChannelName(const NSInteger channel);

#pragma mark - Tool

void NXRMain(dispatch_block_t block);

void NXRPostNotification(NSString *name, id obj, NSDictionary *userinfo);

NSString *NXRBundleFile(NSString *name);

/**
 *  查询是否过期
 *
 *  优先级: 
 *     if 被限流: limited==YES: [[NXRContext configManager] limitReqRate]
 *     else if 业务配置了过期时间 preferUpdateRate: preferUpdateRate
 *     else 通用过期时间 [[NXRContext configManager] updateReqRate]
 */
BOOL NXRRequestExpired(NSTimeInterval lastRefreshDate, BOOL limited, NSNumber *preferUpdateRate);

#pragma mark - Url

NSString *NXRTrimTailingWhiteSpace(NSString *str);

NSURL *NXRURLWithFixedString(NSString *URLString);

/**
 *  入口安全校验
 *
 *  校验逻辑: 对于主入口url,首先匹配和main_url的scheme和host是否完全匹配,不匹配时再sub_url对比,都不匹配时候校验失败
 *  注意
 *      1. 如果urlString为/或file://开头,则直接通过校验
 *      2. SDK内默认对入口URL不做安全校验, 如业务方有安全校验需求可以调用该接口校验
 */
BOOL NXRIsMainUrlValid(NSString *urlString, NXRApp *app);

NXRAppAutoScene NXRSceneType(NSString *scene);

BOOL NXRIsTinyApp(NXRApp *app);
