//
//  NXRProtocol.h
//  NebulaResource
//
//  Created by 扶瑶 on 16/3/11.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#ifndef NXRProtocol_h
#define NXRProtocol_h

@class NXRApp;
#import "NXRDefine.h"
#import <AriverResource/RVRError.h>
#import <AriverResource/RVRProtocol.h>
#import <AriverResource/RVRDefine.h>
#import <AriverResource/RVRLogContext.h>

#pragma mark - Download

@protocol NXRDownloadProtocol <NSObject>

/**
 *  取消下载任务
 *
 *  @param task 任务唯一标识
 */
- (void)cancel:(id)task;

@optional

/**
 *  下载指定url资源
 *
 *  @param url       资源url
 *  @param process   进度回调
 *  @param complete  完成回调
 *
 *  @return 任务唯一标识
 */
- (id)downloadUrl:(NSURL *)url
           params:(NSDictionary *)params
          process:(void (^)(float percent, NSUInteger readBytes, NSUInteger totalBytes))process
         complete:(void (^)(NSString *path, NSData *data, NSError *error))complete;

- (id)downloadUrl:(NSURL *)url
          process:(void (^)(float percent, NSUInteger readBytes, NSUInteger totalBytes))process
           finish:(void (^)(NSString *path, NSError *error))finish;

@end


#pragma mark - Zip

@protocol NXRZipArchiveProtocol <NSObject>

/**
 *  解压文件
 *
 *  @param file      待解压文件地址
 *  @param path      解压后文件地址
 *  @param overwrite 解压时是否覆盖
 *
 *  @return 是否成功
 */
- (BOOL)unzipFile:(NSString *)file
           toPath:(NSString *)path
        overwrite:(BOOL)overwrite;
@end


#pragma mark - Request

@protocol NXRRequestProtocol <RVRRequestManagerDelegate>

/**
 *  请求应用列表
 *
 *  @param dicApps 应用列表{appid:version}
 *  @param params  参数
 *  @param finish  完成回调
 */
- (void)requestApps:(NSDictionary *)dicApps
             params:(NSDictionary *)params
             finish:(void (^)(id data, NSError *error))finish;

/**
 *  批量请求应用列表，直接请求应用中心接口，可返回多个小程序包信息
 *
 *  @param dicApps 应用列表{appid:version}
 *  @param params  参数
 *  @param finish  完成回调
 */
- (void)requestBatchApps:(NSDictionary *)dicApps
                  params:(NSDictionary *)params
                  finish:(void (^)(id data, NSError *error))finish;
@end

#pragma mark - Data Storage



@protocol NXRDataStorageProtocol <NSObject>

/**
 *  获取所有应用信息
 *
 *  @return {appId:{version:NXRApp对象}}
 */
- (NSDictionary *)allApps:(NXRAppAutoScene)autoscene;

/**
 *  保存应用信息
 *
 *  注意: 因灰度功能, 应用信息需要'用户维度'存储
 *
 *  @param apps {appId:{version:NXRApp对象}} 待保存应用列表
 *
 *  @return 是否成功
 */
- (BOOL)saveApps:(NSDictionary *)apps scene:(NXRAppAutoScene)autoscene;

/**
 *  获取已安装应用信息
 *
 *  @return {appid:已安装应用版本号version}
 */
- (NSDictionary *)installedApps:(NXRAppAutoScene)autoscene;

/**
 *  保存已安装应用信息
 *
 *  @param installedApps {appid:已安装应用版本号version}
 *
 *  @return 是否成功
 */
- (BOOL)saveInstalledApps:(NSDictionary *)installedApps scene:(NXRAppAutoScene)autoscene;

/**
 *  获取客户端配置
 *
 *  @return {key:value}
 */
- (NSDictionary *)clientConfigs;

/**
 *  保存客户端配置
 *
 *  @param clientConfigs {key:value}
 *
 *  @return 是否成功
 */
- (BOOL)saveClientConfigs:(NSDictionary *)clientConfigs;

- (NSDictionary *)discardedTemplate;
- (BOOL)saveDiscardedTemplate:(NSDictionary *)dict;

/**
 *  获取指定信息
 *
 *  @param key 键值
 *
 *  @return value
 */
- (id)valueForKey:(NSString *)key;

/**
 *  保存指定信息
 *
 *  @param data 数据
 *  @param key  键值
 *
 *  @return 是否成功
 */
- (BOOL)saveData:(id)data forKey:(NSString *)key;


@optional

#pragma mark - credit

/**
 *  保存智能列表配置
 *
 *  @param list {key:value}
 *
 *  @return 是否成功
 */
- (BOOL)saveCreditList:(NSDictionary *)list;

/**
 *  获取智能列表配置
 *
 *  @param list {key:value}
 *
 *  @return 是否成功
 */
- (NSDictionary *)creditList;

/**
 *  保存本地的包信息中的publicURL配置
 *
 *  @return 是否成功
 */
- (BOOL)savePublicURLs:(NSDictionary *)publicURLs;

/**
 *  获取存储的publicURL配置
 */
- (NSDictionary *)publicURLs;

/**
 *  保存小程序动态配置信息
 *
 *  @return 是否成功
 */
- (BOOL)saveTinyAppConfig:(NSDictionary *)config forKey:(NSString *)key;

/**
 *  获取小程序动态配置信息
 *
 *  @return value
 */
- (NSDictionary *)getTinyAppConfig:(NSString *)key;


#pragma mark - deprecated

- (NSDictionary *)allApps __deprecated;
- (BOOL)saveApps:(NSDictionary *)apps __deprecated;
- (NSDictionary *)installedApps __deprecated;
- (BOOL)saveInstalledApps:(NSDictionary *)installedApps __deprecated;

@end


#pragma mark - credit

/*
 * 数据返回格式指定key
 *
 * NXRCreditResponseData   常用应用列表, value:[{'appId':'','credit':''},...]
 * NXRCreditResponseConfig 优惠策略, value:{'分数':'策略,十六进制'}
 */
extern NSString *const NXRCreditResponseData;
extern NSString *const NXRCreditResponseConfig;

/*
 * 配置说明
 *
 * NXRCreditConfigReqRate               列表请求频率, 默认:24小时
 * NXRCreditConfigReqLimitRate          列表限流频率, 默认:10分钟
 */
extern NSString *const NXRCreditConfigReqRate;
extern NSString *const NXRCreditConfigReqLimitRate;

/*
 * 请求参数
 *
 * NXRCreditReqParamsForce 强制请求,不受频率限制
 */
extern NSString *const NXRCreditReqParamsForce;

@protocol NXRCreditProtocol <NSObject>

/*
 * 业务需定制获取智能列表通道, SDK暂无默认通道, 必须接入rpc
 * data格式见上述「数据返回格式」
 */
- (void)fetchCreditlist:(NSDictionary *)params finish:(void (^)(id data, NSError *error))finish;

/*
 * 智能统计行为配置, 见上述「配置说明」
 */
- (NSDictionary *)config;

@end


#pragma mark - Log



@interface NXRLogContext: RVRLogContext

+ (NXRLogContext *)type:(NXRLogType)type
                   step:(NXRLogStep)step;

+ (NXRLogContext *)type:(NXRLogType)type
                   step:(NXRLogStep)step
                  error:(NSError *)error
                   data:(NSDictionary *)data;

+ (NXRLogContext *)type:(NXRLogType)type
                cusStep:(NSString *)cusStep
                   data:(NSDictionary *)data;

+ (NXRLogContext *)type:(NXRLogType)type
                cusStep:(NSString *)cusStep
                  error:(NSError *)error
                   data:(NSDictionary *)data;

+ (NXRLogContext *)type:(NXRLogType)type
                   data:(NSDictionary *)data;
@end


@protocol NXRLogProtocol <RVRLogManagerDelegate>
@optional

/**
 *  输出log
 *
 *  @param context log上下文
 */
- (void)logContext:(NXRLogContext *)context;
@end

#pragma mark - Config

@protocol NXRDynamicConfigProtocol <NSObject>
@optional
//高保障配置开关
- (NSDictionary *)highReleaseConfig;
/**
 *  是否为覆盖安装
 *
 *  说明: 如果配置了预置应用列表, 覆盖安装时候会用预置列表覆盖一次磁盘缓存
 */
- (BOOL)coverInstall;

/**
 *  返回用户userId
 *
 *  注意: 该值只在开启用户模式下生效
 *  说明: 默认加入灰度规则中, 为nil时候认为未登录
 */
- (NSString *)currentUserId;

/**
 *  返回网络状态, 辅助判断下载时机等
 */
- (NXRNetworkStatus)networkStatus;

/**
 *  是否强制下载离线包
 *
 *  说明: 请求成功后会判断是否需要下载离线包, 可通过该方法配置, 如果应用配置了auto_install=YES,则不受该方法限制,强制下载
 *  
 *  已废弃,下载时机统一由平台通过参数配置,请实现networkStatus函数返回网络环境辅助判断
 */
- (BOOL)forcedDownload __deprecated;


/**
 *  是否使用mmap方式读取tar文件
 */
- (BOOL)useMmapReadTar;

/**
 *  离线资源匹配附加功能开关，如publicUrls匹配
 */
- (NSDictionary *)resManifestSwitchers;

/**
 * 是否允许预下载, 默认:是
 */
- (BOOL)enablePreDownload:(NSString *)appId;


/**
 4G预下载增加开关白名单管控
 @return 白名单列表AppId
 */
- (BOOL)enablePreDownloadWith4G:(NSString *)appId;

/**
 包降级逻辑开关
 @return 白名单列表AppId
 */
- (BOOL)shouldAppDowngrade:(NSString *)appId;

/**
 指定appId降级后设置的启动超时时间, 无配置需返回-1, >=0内部均会执行
 @return 超时时间
 */
- (double)packageDowngradePrepareTimeLimit:(NSString *)appId;

/**
 * 指定appId启动超时时间, 无配置需返回-1, >=0内部均会执行
 */
- (double)prepareTimeLimit:(NSString *)appId isForce:(BOOL)force;

/**
 * 是否允许进入app时异步解压包文件
 */
- (BOOL)enableAsyncUnzipWhenLaunchingApps;

/**
 * 在解压结束后是否使用高优先级队列进行回调
 */
- (BOOL)callbackInHighPriorityAfterUnzip;

/**
 * 是否开启小程序动态配置
 */
- (BOOL)enableTinyappConfig;

/**
 * 针对 appId 纬度配置的拉包配置
 */
- (NSDictionary *)clientConfigForApps;

/**
 * 客户端配置, 默认读取nebulamng客户端配置, 可定制读取内容
 *
 * @param  key       字符串, 指定具体开关key
 *         shortKey  字符串, key缩写
 *         error     指针地址, error不为空时降级使用nebulamng客户端配置
 * @return id        开关值
 */
- (id)clientConfigForKey:(NSString *)key shortKey:(NSString *)shortKey error:(NSError **)error;

/**
 *  模版小程序总开关
 */
- (BOOL)enableTemplateApp;

/**
 *  模版小程序配置信息等待时间
 */
- (NSTimeInterval)preferConfigWaitTime;

/**
 * 是否在新包管理中开启Ariver链路
 */
- (BOOL)enableNebulaAriver;

/**
 * 是否在开启saveApps优化
 */
-(BOOL)optimizationForSaveApps;
/**
 *插件过期时间
 *
 */
- (NSTimeInterval)pluginExpireTime;

/**
 是否将fallback资源返回头和离线包返回头保持一致
*/
- (BOOL)enableRemoveFallbackHeaders;

/**
 fallback资源返回头透回给内核的白名单
*/
- (NSArray *)fallbackHeadersWhitelist;

/**
 ccdn 动态必要资源列表
 */
- (NSArray *)ccdnNecessaryResList;

/**
 本地最多保留2个版本的安装包
*/
- (NSArray *)keepLastInstallationWhitelist;
/**
    appx 最小版本号，用于止血
*/
- (NSString *)minSDKVersion;
/**
 返回资源包共享内存对象
 */
- (BOOL )appDataSourceFromCache;

/**
 是否记录appxng的降级原因
 */
- (BOOL)enableLogAppxNGError;

/**
 修复startApp时候带appxRouteFramework=NO参数
 */
- (BOOL)fixRestartAppWithNoAppxRoute;

/**
修复DataSourceManager对象出错还进行网络拦截
*/
- (BOOL)fixInvalidDataSourceManager;

- (BOOL)fixNullCurSessionBeforeAppxRoute;

//! 优先预下载的appId
- (NSArray *)prefered4GAppIds;

//是否从小程序启动参数中加载业务资源包
- (BOOL)loadNbpkgresFromTinyConfig;

- (NSDictionary *)configForUsePkgUrlInfo;

- (NSDictionary *)CCDNFixConfig;

- (NSDictionary *)downgradeVersionConfig;

- (NSDictionary *)downgradePreparetimelimitConfig;
@end

#pragma mark - App Interface

@protocol NXRAppInterface <RVRAppInterfaceDelegate>
@optional

/**
 *  是否支持NebulaApp
 *
 *  说明: 
 *      支持: 从包管理池中读取对象, 如果对象不存在, 则通过以下findApp:version:方法读取定制的应用对象
 *      不支持: 直接通过以下 findApp:version: 方法读取定制的应用对象
 */
- (BOOL)supportNebulaApp:(NSString *)appid version:(NSString *)version __deprecated;
- (BOOL)supportNebulaApp:(NSString *)appid version:(NSString *)version nebulaVersion:(NSString **)nebulaVersion;

/**
 *  定制应用对象
 */
- (NXRApp *)findApp:(NSString *)appid version:(NSString *)version;

/**
 *  配置指定应用id不被删除的版本号
 *
 *  说明: 应用信息池受容量控制, 当超过最大容量时会默认删除最小版本号应用信息, 可通过该方法配置不可删除的版本
 */
- (NSArray *)permanentVersionsForApp:(NSString *)appid sceneType:(NXRAppAutoScene)sceneType;

/**
 *  在公共离线资源未下载完成的场景下, 是否允许离线包降级至已安装版本
 *
 *  说明: 可降级至已安装版本/预置版本, 默认:NO
 */
- (BOOL)enableCommonResourceDegrade:(NSString *)appid;


/**
 *  获取应用场景
 *  注: 仅钱包内调试模式使用
 */
- (NSString *)sceneForApp:(NSString *)appId;

/**
 *  是否允许强大request, sdk默认允许
 */
- (BOOL)enableStableReq;

/**
 *  是否支持加载指定公共appId资源
 */
- (BOOL)enableLoadPubAppId:(NSString *)appid contextApp:(NXRApp *)contextApp version:(NSString **)version;

/**
 * 是否允许加载业务资源包, 默认:是
 */
- (BOOL)enableLoadPkgResApps:(NSNumber **)numLimit;

/**
 * 是否允许忽略预置信息入口版本, 取最高版本, 默认:是
 */
- (BOOL)enableIgnorePresetVersion;

/**
 * 是否是资源型应用
 */
- (BOOL)isResApp:(NSString *)appId;

/**
 * 是否允许强制下载时取消已存在任务 10.1.10
 */
- (BOOL)enableForceDownloadCancel;

/**
 * 查看预置离线包信息
 */
- (NSDictionary *)presetAmrApps;

/**
 * 是否允许同步解压预置资源
 */
- (BOOL)enableSyncUnzipPresetAmr;

/**
 * 是否允许取消正在下载中高优先级下载任务
 */
- (BOOL)disableCancelHighPriorityTask;

@end

#pragma mark - TinyAppConfig

// 小程序动态配置更新代理
@protocol NXRTinyAppConfigProtocol <NSObject>

@required

/**
 * 给定cdn地址，下载其配置值
 */
- (void)downloadConfig:(NSString *)cdnUrl finish:(void (^)(NSDictionary *, NSError *))finish;

@optional

/**
 * 通过兜底rpc获取某个小程序指定的配置值
 */
- (void)fetchConfig:(NSString *)appId key:(NSString *)key finish:(void (^)(NSString *))finish;

@end


#endif /* NXRProtocol_h */
