//
//  NXRApp.h
//  NebulaResource
//
//  Created by chenwenhong on 15/9/16.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//


#import <AriverResource/RVRApp.h>
@class NXRApp;

typedef enum{
    NXRCCDNSuccAndCache,
    NXRCCDNSuccAndReq,
    NXRCCDNLoading,
    NXRCCDNUnknow
}NXRCCDNLoadDataResult;

@protocol NXRCCDNDelegateProtocol <NSObject>
-(BOOL)canUseCCDN:(NSString *)packageUrl appId:(NSString *)appId;
-(BOOL)packageStatusIsInstalled:(NXRApp *)app;
-(void)preloadDataWithAppInfo:(NXRApp *)app;
-(void)appExitWithAppInfo:(NXRApp*)app;
-(NXRCCDNLoadDataResult) loadDataWithAppInfo:(NXRApp *)app process:(NXRAppInstallProcess)process finish:(NXRAppInstallFinish)finish;
@end

@class CCDNAppInfo;
@interface NXRApp : RVRApp

@property (nonatomic) BOOL isCheckingCanUseNewPkgUrl; // 正在评估是否可以使用NewPkgUrl字段
@property (nonatomic, readonly, copy) NSString * appDist;//默认为空，则CN，区分地区MO,HK 10.1.65新增
-(BOOL)isRegionMatched;
-(BOOL)isInCCDNWhitelist;
-(BOOL)isAllPluginsInstalled;

-(CCDNAppInfo *)ccdnAppInfo;
-(NSString *)appNGPrefix;
//是否依赖appx2.0(68687209)框架
-(BOOL)isAppxNG;

-(void)updateCCDNCallback:(NSDictionary *)ccdnCallback;
@property (nonatomic, copy ,readonly) NSArray * ccdnNecessaryResList;
@property(nonatomic,strong,readonly) NSDictionary<NSString*,NSString*> *callbackExtInfo;
@end

