//
//  NPWarningTip.h
//  NebulaPlugins
//
//  Created by Glance on 2018/7/31.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverNebulaBiz/NBWarningTipInterface.h>

typedef NS_ENUM(NSUInteger, NPWarningTipType) {
    NPWarningTipTypeVisit,
    NPWarningTipTypeDataFlow,
    NPWarningTipTypeInput,
    NPWarningThirdPartTinyApp,
};

@interface NPWarningTip : NSObject<NBWarningTipInterface>

@property (nonatomic, assign) BOOL isWarningVisit;

/**
 添加公告投放

 @param vc 展示的窗口对象
 @param tipType 公告类型:页面访问/流量/输入提示
 @param content 提示内容
 @param autoHide 是否5秒内自动隐藏
 @param spmId 埋点的spmId
 */
+ (void)addTipViewWithVC:(H5WebViewController *)vc
                tipType:(NPWarningTipType)tipType
                content:(NSString *)content
                autoHide:(BOOL)autoHide
                   spmId:(NSString *)spmId;


/**
 翻页时重置现场，统一处理，请勿调用
 */
- (void)reset;


/**
 处理窗口销毁逻辑
 */
- (void)handleViewControllerDidDestroy;

@end
