//
//  NXEEngine.h
//  NebulaEngine
//
//  Created by 张光宇 on 2018/8/13.
//  Copyright © 2018 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NXEHandlerManager.h"
#import <NebulaApp/NXEngineViewProtocol.h>
//#import "NXEngineInstance.h"


NS_ASSUME_NONNULL_BEGIN

/**
 NXEEngine启动流程:
 1. 准备参数，做一些应急处理
 2. createView
 */
@interface NXEEngine : NSObject

+ (id<NXEngineView> )createView:(RVKKernel<NXEngineViewDelegate> *)viewDelegate;
@end

@interface NXEEngine(API)

// 在 baseUserAgent 基础上，带上容器和应用信息的 UA 串
+ (NSString *)userAgent;

// 只有系统默认 UA 信息 + 'ChannelId(0) NebulaSDK/1.8.100112 Nebula'
+ (NSString *)baseUserAgent;

// public
+ (BOOL)hasDowngradeErrorOccured:(NSDictionary *)info;
@end

NS_ASSUME_NONNULL_END
