//
//  NXOptionsUtil.h
//  NebulaApp
//
//  Created by lyusheng on 2019/12/31.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NXOptionsSecDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface NXOptionsUtil : NSObject
+ (NSDictionary *)optionsCheckEvent:(NSDictionary *)options
                             source:(NXOptionSource)source
                                app:(RVRApp *)app;

/// 参数过滤的入口方法
/// @param options 参数列表
/// @param source 来源
/// @param app 包管理对象appp
/// @param appId app唯一标识符
/// @param url url参数很重要，如果知道当前页面的url，则需要传入，用来强判断当前页面是否集团url
+ (NSDictionary *)optionsCheckEvent:(NSDictionary *)options
                             source:(NXOptionSource)source
                                app:(RVRApp *_Nullable)app
                              appId:(NSString *_Nullable)appId
                                url:(NSString *_Nullable)url;

+ (NSDictionary *)dictionaryDiffCompare:(NSDictionary *)dictionary with:(NSDictionary *)dictionary;

@end

NS_ASSUME_NONNULL_END
