//
//  NXAPageT2Profile.h
//  NebulaApp
//
//  Created by lyusheng on 2020/7/1.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, NXAT2Error) {
    NXAT2ErrorNone = 0,
    NXAT2ErrorStatusOff = -1001, // 未计算
    NXAT2ErrorNoEndTs = -1002,
    NXAT2ErrorEmptyData = -1003
};

NS_ASSUME_NONNULL_BEGIN

@interface NXAPageT2Profile : NSObject

@property (nonatomic) NSMutableDictionary<NSNumber*,NSDictionary *> *t2End; // key: ts, value: type
@property (nonatomic) NSMutableDictionary<NSNumber*,NSDictionary *> *domDiff; // key: ts, value: type

@property (nonatomic) NSMutableDictionary<NSNumber*,NSDictionary *> *domLogs; // key: ts, value: type

- (long)computeT2:(NSError **) error;

- (void)logData:(NSDictionary *)data;

- (NSString *)detailLog;
- (NSString *)detailLogWithStartTs:(long long)startTs;

@end

NS_ASSUME_NONNULL_END
