//
//  NXAContext.h
//  NebulaApp
//
//  Created by lyusheng on 2018/8/15.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <AriverApp/RVAContext.h>

#define kAppErrorDowngradeCheck @"NewYearAppErrorDowngradeCheck"

@class NXAAppSession;
@class NXAAppContext;

@interface NXAContext : RVAContext

+ (instancetype)sharedIntance;

// ----------- override -------------
// 被UINavigationController 的lifecycle hook方法调用
- (void)pushSession:(RVASession *)session;

// 被RVASession调用
- (void)popSession:(RVASession *)session;

- (NSArray *)sessions;

// 以下方法在新容器中不被调用，无须override
//- (void)showSession:(RVASession *)session;
//- (void)hideSession:(RVASession *)session;
//- (RVASession *)createSession:(RVASessionContext *)context;

- (RVASession *)currentSession;
- (BOOL)startSession:(NSDictionary *)params animated:(BOOL)animated;
- (void)exitSession:(RVASession *)session animated:(BOOL)animated;

// ----------- non-override -------------
- (NXAAppSession *)createApp:(NSDictionary *)dictionary;
// vcCls / contentViewCls 目前还是直接直接传进来
- (NXAAppSession *)createApp:(NSDictionary *)dictionary appId:(NSString *)appId viewControllerClass:(Class)vcCls contentViewClass:(Class)viewCls;
- (void)showApp:(NXAAppSession *)app;
- (void)hideApp:(NXAAppSession *)app;
@end
