//
//  NBAuthExtensionInfo.h
//  NBInside
//
//  Created by 张光宇 on 2020/2/7.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface NBAuthExtItem : NSObject
@property (nonatomic, strong) NSString *jsapiName;
@property (nonatomic, strong) NSString *storageKey;
@property (nonatomic, strong) NSString *displayNameInSetting;
@property (nonatomic, strong) NSString *authDesc;
@end

@interface NBAuthExtensionManager : NSObject

+ (instancetype)sharedInstance;

@property (nonatomic, strong) NSArray<NBAuthExtItem *> *jsapiAuthItems;
- (NSArray *)ordedKeysInSettingVC;

- (NSDictionary *)authDescDictionary;
- (NSDictionary *)displayNameInSettingDictionary;
- (NBAuthExtItem *)authItemForStorageKey:(NSString *)storageKey;
- (NBAuthExtItem *)authItemForJsApi:(NSString *)jsapi;

@end

NS_ASSUME_NONNULL_END
