//
//  MPEnvironmentUtil.h
//  MPSecurityAdapter
//
//  Created by yemingyu on 2021/1/15.
//  Copyright © 2021 Alipay. All rights reserved.
//

#ifndef MPEnvironmentUtil_h
#define MPEnvironmentUtil_h

#import <MPSecurityAdapter/MPEnvironmentUtilImpl.h>

/**
 *  在调用一个类函数 sel 之前，检查该函数是否被外部注入库 hook，仅适用于主二进制中的 selector，不适用于系统 API 与动态库
 *  ------------------------------------------------------
 *  @param className NSString 类型，selector 所属类名
 *  @param sel  SEL 类型，selector
 *
 *  @return 返回值类型为 BOOL，YES 表示该 selector 已被 hook
 *  ------------------------------------------------------
 *
 *  示例如下:
 *  BOOL isHooked = MPAASCheckClsSelSwizzling(@"xxxCls", @selector(xxxSel));
 *
 */
#define MPAASCheckClsSelSwizzling(className, sel) (MPEnvironmentUtilImpl->isSwizzlingClsMethod(className, sel))

/**
*  在调用一个实例函数 sel 之前，检查该函数是否被外部注入库 hook，仅适用于主二进制中的 selector，不适用于系统 API 与动态库
*  ------------------------------------------------------
*  @param className NSString 类型，selector 所属类名
*  @param sel  SEL 类型，selector
*
*  @return 返回值类型为 BOOL，YES 表示该 selector 已被 hook
*  ------------------------------------------------------
*
*  示例如下:
*  BOOL isHooked = MPAASCheckInsSelSwizzling(@"xxxCls", @selector(xxxSel));
*
*/
#define MPAASCheckInsSelSwizzling(className, sel) (MPEnvironmentUtilImpl->isSwizzlingInsMethod(className, sel))

/**
* 检测包的 bundleId 是否被修改，从而检测是否被重打包
*  ------------------------------------------------------
*  @param bundleId NSString 类型，原始 bundleId
*
*  @return 返回值类型为 BOOL，YES 表示该 bundleId 已被 修改
*  ------------------------------------------------------
*
*  示例如下:
*  BOOL isChanged = MPAASCheckBundleIdChanged(@"xxxBundleId");
*
*/
#define MPAASCheckBundleIdChanged(bundleId) (MPEnvironmentUtilImpl->isBundleIdChanged(bundleId))

/**
* 检测包的证书 teamId 是否被修改，从而检测是否被重打包
*  ------------------------------------------------------
*  @param teamId NSString 类型，原始证书 teamId
*
*  @return 返回值类型为 BOOL，YES 表示该 teamId 已被 修改，已被重打包
*  ------------------------------------------------------
*
*  示例如下:
*  BOOL isChanged = MPAASCheckRePackage(@"xxxteamId");
*
*/
#define MPAASCheckRePackage(teamId) (MPEnvironmentUtilImpl->isRePackage(teamId))

#endif /* MPEnvironmentUtil_h */
