//
//  MPLBSLocationManager.h
//  APMobileLBS
//
//  Created by shifei.wkp on 2019/4/6.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APMobileLBS/LBSLocationDefs.h>

NS_ASSUME_NONNULL_BEGIN

@class MPLBSConfiguration;
@class MPLBSLocationInfo;

/**
 定位结果的回调 block
 
 @param success 是否成功
 @param locationInfo 位置信息
 @param error 定位失败的错误信息
 */
typedef void(^MPLBSLocationCompletionBlock)(BOOL success,
                                            MPLBSLocationInfo *locationInfo,
                                            NSError *error);

/**
 定位服务
 */
@interface MPLBSLocationManager : NSObject

// TODO: 增加定位上报配置

/**
 初始化
 
 @param configuration 参数配置
 @return 实例
 */
- (instancetype)initWithConfiguration:(MPLBSConfiguration *)configuration;

/**
 发起单次定位
 
 @param needReGeocode 是否需要逆地理信息
 @param block 定位结束的回调block
 */
- (void)requestLocationNeedReGeocode:(BOOL)needReGeocode
                   completionHandler:(MPLBSLocationCompletionBlock)block;

/**
 根据提供的位置，获取对应的逆地理信息
 
 @param block 回调block
 */
- (void)requestReGeocodeOfLocationWithCompletionHandler:(MPLBSLocationCompletionBlock)block;

/**
 主动上报当前位置信息（位置签到）
 @param location 输入 CLLocation 对象，从获取定位的回调接口里可以拿到
 @param block 回调block
 */
+ (void)reportLocationInfoWithLocation:(CLLocation *)location
                     completionHandler:(nullable void(^)(BOOL))block;

@end

NS_ASSUME_NONNULL_END
