//
//  MPLBSLocationInfo.h
//  APMobileLBS
//
//  Created by shifei.wkp on 2019/4/6.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 逆地理信息
 */
@interface MPLBSReGeocodeInfo : NSObject

@property (nonatomic, strong) NSString* country;        // 国家
@property (nonatomic, strong) NSString* countryCode;    // 国家编码
@property (nonatomic, strong) NSString* provience;      // 省
@property (nonatomic, strong) NSString* city;           // 城市
@property (nonatomic, strong) NSString* district;       // 区
@property (nonatomic, strong) NSString* street;         // 街道
@property (nonatomic, strong) NSString* streetCode;     // 街道编码
@property (nonatomic, strong) NSString* cityCode;       // 城市编码
@property (nonatomic, strong) NSString* adCode;         // 行政区划编码
@property (nonatomic, strong) NSArray* poiList;         // poi 信息列表

@end

/**
 定位结果的位置信息数据结构
 */
@interface MPLBSLocationInfo : NSObject

@property (nonatomic, strong) CLLocation* location;         // 位置信息
@property (nonatomic, strong) MPLBSReGeocodeInfo* rgcInfo;  // 逆地理信息

@end

NS_ASSUME_NONNULL_END
