//
//  MPLBSConfiguration.h
//  APMobileLBS
//
//  Created by shifei.wkp on 2019/3/30.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
//#import <APMobileLBS/LBSLocationDefs.h>

NS_ASSUME_NONNULL_BEGIN

/**
 定位服务的配置
 */
@interface MPLBSConfiguration : NSObject

/** 单次定位期望精度，单位米，建议结合业务场景传入一个可接受正数，如500，即500m以内的范围 */
@property (nonatomic, assign) CLLocationAccuracy desiredAccuracy;

/** 单次定位接受的缓存时间，从当前时间往前推，多长时间内的缓存是有效的，推荐设置30s以上的缓存时间 */
@property (nonatomic, assign) APCoreLocationCacheAvaliable cacheTimeInterval;

/** 单次定位或逆地理查询的超时时间，单位秒，默认和最小设置为2s */
@property (nonatomic, assign) NSTimeInterval timeOut;

/** 逆地理查询的信息级别，默认APCoreLocationReGeoLevelDistrict */
@property (nonatomic, assign) LBSLocationReGeoLevel reGeoLevel;

/** 逆地理查询的位置信息，在其中指定经纬度坐标 */
@property (nonatomic, strong) CLLocation *reGeoLocation;

/** 逆地理查询位置信息是否为高德坐标系，默认YES（使用 reGeoLocation 参数时生效） */
@property (nonatomic, assign) BOOL reGeoCoordinateConverted;

/** 是否打开签到功能，默认NO（按需设置打开） */
@property (nonatomic, assign) BOOL needCheckIn;

/**
 *  是否需要高精度定位，iOS14以下不区分精度，iOS14及以上默认NO(低精度)，需要业务指定是否需要高精度定位。
 */
@property (nonatomic,assign) BOOL highAccuracyRequired;

@end

NS_ASSUME_NONNULL_END
