//
//  MASSURLRequstMethod.h
//  MASSProxy
//
//  Created by cuinacai on 2020/11/24.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, MASSRequestCallbackThreadType)
{
    MASSRequestCallbackThreadTypeDefault = 0,    //默认线程
    MASSRequestCallbackThreadTypeResidentThread, //指定常驻线程
};

typedef NS_ENUM(NSInteger, MASSRequestMethodType)
{
    MASSRequestMethodTypeDownload = 0,    //下载数据
    MASSRequestMethodTypeUpload, //上传数据
};

typedef NS_ENUM(NSInteger, MASSCcdnCachePolicy)
{
    MASSCcdnCachePolicyDefault = 0,    //采用CCDN默认的策略
    MASSCcdnCachePolicyDisable = 1     //不走CCDN
};

typedef NS_ENUM(NSInteger, MASSCloudType)
{
    MASSCloudTypeDefault = 0,         //默认H5通道
    MASSCloudTypeTinyAppCloud = 1     //小程序云
};

typedef NS_ENUM(NSInteger, MASSReturnDataType)
{
    MASSReturnDataTypeStream = 0,      //数据流式返回，分多次返回，跟进度（processiveHandle）一起返回
    MASSReturnDataTypeOnceData = 1     //一次返回，最后completionHandler时候返回
};

//请求对象，一个请求创建一个
@interface MASSURLRequstMethod : NSObject
@property(nonatomic,strong)NSURLRequest* _Nonnull request;//请求体
@property(nonatomic) NSString* _Nonnull bizType;          //业务类型，区分具体业务
@property(nonatomic,strong) NSString* _Nullable bizLog;  //业务方想填在网络层埋点的日志，长度限制128
//@property(nonatomic,strong) NSDictionary<NSString*,NSString*>* _Nullable extParams;//扩展参数，可空
//回调线程的类型，默认是MASSRequestCallbackThreadTypeDefault
@property(nonatomic) MASSRequestCallbackThreadType callbackThreadType;
//callbackThread是回调时候的线程，该值为空的话可能会使用网络这边的线程（注意：callbackThread一定要是常驻线程）
//callbackThreadType == MASSRequestCallbackThreadTypeResidentThread时候用
@property (atomic, strong) NSThread * _Nullable callbackThread;
//modes是callbackThread对应的mode，modes空（nil或者空数组）时候会使用NSDefaultRunLoopMode
@property (atomic, copy) NSArray * _Nullable modes;
//如果为YES则会在请求里面返回extInfo信息，否则不返回
@property(nonatomic)BOOL enableExtInfo;

/**
 * 添加请求一条Tag
 *
 * @param value
 *            请求Tag value
 * @param key
 *            请求Tag name
 */
-(void)addTags:(NSString*_Nullable)value forKey:(NSString*_Nonnull)key;
@end

//上传接口生效
@interface MASSURLRequstMethod(UploadRequest)
//上传路径
@property(nonatomic,strong)NSString * _Nullable filePath;
@end

//下载接口生效
@interface MASSURLRequstMethod(DwonloadRequest)
//数据返回类型
@property(nonatomic,assign)MASSReturnDataType returnDataType;
@end

@interface MASSURLRequstMethod(DTN)
//业务勿用
@property(nonatomic)BOOL enableDtn;
//强制enableHttp2会走DTN，默认NO
@property(nonatomic)BOOL enableHttp2;
@end

@interface MASSURLRequstMethod(CCDN)
//CCDN cache Policy 默认为 MASSCcdnCachePolicyDefault
@property(nonatomic)MASSCcdnCachePolicy ccdnCachePolicy;
@end

@interface MASSURLRequstMethod(NetChannelType)
//netChannelType 默认为 MASSNetChannelTypeDefault
@property(nonatomic)MASSCloudType cloudType;
@end

@interface MASSURLRequstMethod(Timeout)
//socketTimeout，单位为秒，默认不传（底层默认值）
@property(nonatomic)int socketTimeout;
@end

