//
//  MASSSessionCallback.h
//  MASSProxy
//
//  Created by cuinacai on 2020/7/16.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef void (^DidReceiveResponseCompletionHandler)(NSURLSessionResponseDisposition disposition);
typedef void (^WillCacheResponseCompletionHandler)(NSCachedURLResponse * _Nullable cachedResponse);
typedef void (^WillPerformHTTPRedirectionCompletionHandler)(NSURLRequest * _Nullable);
typedef void (^NeedNewBodyStreamCompletionHandler)(NSInputStream * _Nullable bodyStream);

#pragma -mark NSURLSessionDataDelegate

typedef void (^MASSSessionDataDidReceiveResponseBlock)(NSURLSession *session,NSURLSessionDataTask *dataTask,NSURLResponse *response,DidReceiveResponseCompletionHandler completionHandler);

typedef void (^MASSSessionDataDidBecomeDownloadTaskBlock)(NSURLSession *session,NSURLSessionDataTask *dataTask,NSURLSessionDownloadTask *downloadTask);

typedef void (^MASSSessionDataDidBecomeStreamTaskBlock)(NSURLSession *session,NSURLSessionDataTask *dataTask,NSURLSessionStreamTask *streamTask);

typedef void (^MASSSessionDataDidReceiveDataBlock)(NSURLSession *session,NSURLSessionDataTask *dataTask,NSData *data);

typedef void (^MASSSessionDataWillCacheResponseBlock)(NSURLSession *session,NSURLSessionDataTask *dataTask,NSCachedURLResponse *proposedResponse,WillCacheResponseCompletionHandler completionHandler);

#pragma mark - NSURLSessionTaskDelegate

typedef void (^MASSSessionWillPerformHTTPRedirectionBlock)(NSURLSession *session,NSURLSessionTask *task,NSHTTPURLResponse *response,NSURLRequest *request,WillPerformHTTPRedirectionCompletionHandler completionHandler);

typedef void (^MASSSessionNeedNewBodyStreamBlock)(NSURLSession *session,NSURLSessionTask *task,NeedNewBodyStreamCompletionHandler completionHandler);

typedef void (^MASSSessionDidSendBodyDataTotalBytesSentBlock)(NSURLSession *session,NSURLSessionTask *task,int64_t bytesSent,int64_t totalBytesSent,int64_t totalBytesExpectedToSend);

typedef void (^MASSSessionDidFinishCollectingMetricsBlock)(NSURLSession *session,NSURLSessionTask *task,NSURLSessionTaskMetrics *metrics);

typedef void (^MASSSessionDidCompleteWithErrorBlock)(NSURLSession *session,NSURLSessionTask *_Nullable task,NSError *_Nullable error);



@interface MASSSessionCallback : NSObject
+ (MASSSessionCallback*)callbackDidReceiveResponse:(MASSSessionDataDidReceiveResponseBlock)didReceiveResponseHandle
                             didBecomeDownloadTask:(MASSSessionDataDidBecomeDownloadTaskBlock)didBecomeDownloadHandle
                               didBecomeStreamTask:(MASSSessionDataDidBecomeStreamTaskBlock)didBecomeStreamTaskHandle
                                    didReceiveData:(MASSSessionDataDidReceiveDataBlock)didReceiveDataHandle
                                 willCacheResponse:(MASSSessionDataWillCacheResponseBlock)willCacheResponseHandle
                        willPerformHTTPRedirection:(MASSSessionWillPerformHTTPRedirectionBlock)willRedirectionHandle
                                 needNewBodyStream:(MASSSessionNeedNewBodyStreamBlock)needNewBodyStreamHandle
                     didSendBodyDataTotalBytesSent:(MASSSessionDidSendBodyDataTotalBytesSentBlock)didSendBodyDataHandle
                           finishCollectingMetrics:(MASSSessionDidFinishCollectingMetricsBlock)collectingMetricsHandle
                              didCompleteWithError:(MASSSessionDidCompleteWithErrorBlock)didCompleteHandle;
@property(nonatomic,copy) MASSSessionDataDidReceiveResponseBlock didReceiveResponseHandle;
@property(nonatomic,copy) MASSSessionDataDidBecomeDownloadTaskBlock didBecomeDownloadHandle;
@property(nonatomic,copy) MASSSessionDataDidBecomeStreamTaskBlock didBecomeStreamTaskHandle;
@property(nonatomic,copy) MASSSessionDataDidReceiveDataBlock didReceiveDataHandle;
@property(nonatomic,copy) MASSSessionDataWillCacheResponseBlock willCacheResponseHandle;
@property(nonatomic,copy) MASSSessionWillPerformHTTPRedirectionBlock willRedirectionHandle;
@property(nonatomic,copy) MASSSessionNeedNewBodyStreamBlock needNewBodyStreamHandle;
@property(nonatomic,copy) MASSSessionDidSendBodyDataTotalBytesSentBlock didSendBodyDataHandle;
@property(nonatomic,copy) MASSSessionDidFinishCollectingMetricsBlock collectingMetricsHandle;
@property(nonatomic,copy) MASSSessionDidCompleteWithErrorBlock didCompleteHandle;
@end

NS_ASSUME_NONNULL_END
