//
//  MASSProxyControl.h
//  MASSProxy
//
//  Created by cuinacai on 16/3/9.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void (^MASSInitializeBlock)();

@class MASSTFSDownMethod;

@protocol MASSProxyLogDelegate <NSObject>

/**
 *	@brief	打埋点日志接口，
 *
 *	@param 	pfx ,sybType, content, 扩展字段，共四个item，第四个item是字典，字典内容可自定义，
 字典会被转换成key-value的字符串计入日志
 *
 *	@return 返回value
 */
-(void)logwithSubType:(NSString*)pfx content:(NSArray*)content;
//用APLogInfo打日志
-(void)writeLocalLogInfo:(NSString *)tag params:(NSArray*)params;
//ccdn埋点
-(void)logwithCCDNSubType:(NSString*)pfx content:(NSArray*)content;
//不可用埋点
-(void)MTBIZ_Report:(NSString*)bizName subName:(NSString*)subName failCode:(NSInteger)failCode params:(NSDictionary*)params;
//是否在后台
- (BOOL)isBackground;
- (BOOL)isAppOnlineEv;
@end

extern id<MASSProxyLogDelegate>  massLogger;

@interface MASSProxyControl : NSObject
//单例
+ (instancetype)shareInstance;
//mass开关
+(BOOL)massSwitch;
//fetch wifi过滤
+(BOOL)fetchFilter;
+(BOOL)streamLoad;
@property(nonatomic,copy)MASSInitializeBlock channelInitBlock;
@property(nonatomic,readonly)BOOL ccdnSwitch;
@property(nonatomic,readonly)BOOL tinyappeSwitch;
@property(nonatomic,readonly)BOOL syncQueryTinyappSwitch;
@property(nonatomic, readonly)BOOL hasRegInitialize;

@property(nonatomic,readonly)BOOL h5crc;
@property(nonatomic,readonly)BOOL useThreadPool;
@property(nonatomic,readonly)BOOL supportCleanCache;
@property(nonatomic,readonly)BOOL supportCleanTinyAppCache;
@property(nonatomic,readonly)BOOL ccdnQueryIgnore304;
@property(nonatomic,readonly)BOOL ccdnCheckUseNew;
@property(nonatomic,readonly)BOOL needAppTrace;
@property(nonatomic,readonly)BOOL needPxyThread;
@property(nonatomic,readonly)BOOL prePushUrlSwitch;
@property(nonatomic,readonly)BOOL ccdnPreTestOpen;
@property(nonatomic,readonly)BOOL retErr;
@property(nonatomic,readonly)BOOL enableHttpUrlCache;
@property(nonatomic,readonly)BOOL needUNGzip;
@property(nonatomic,readonly)BOOL enableCallbackAsyncThread;
@property(nonatomic, readonly)float maxHttpEntryCacheSize;
@property(nonatomic, readonly)float maxPrePushHttpEntryCacheSize;
@property(nonatomic, readonly) float maxPrePushPackageSize;
@property(nonatomic,readonly)BOOL reportPreResFirstAccess;
@property(nonatomic, readonly)BOOL usingNewH5Metrics;

//指定头上报
@property(nonatomic,readonly)BOOL headerDump;
@property(atomic,readonly)NSArray *dumpList;
@property(nonatomic)BOOL hasInitMass;
/// 只有预加载支持增量更新
@property(nonatomic)BOOL pkgPatchOnPrefetch;
/// 非加载或者预加载支持增量更新
@property(nonatomic)BOOL pkgPatchOnAllAppLoad;
/// 增量更新前是否检查内存水位
@property(nonatomic)BOOL checkMemoryOnPatch;

/// 是否流式回调下载数据
@property(nonatomic)BOOL streamProgress;

//mass初始化block
-(void)setMASSChannelInitializeBlock:(MASSInitializeBlock)block;
//mass的logger
-(void)registerMASSLogWriter:(id<MASSProxyLogDelegate>)logger;
//ccdn config
-(void)setCCDNConfig:(NSDictionary*)config;
-(void)setCCDNH5Config:(NSDictionary*)config;
-(void)setCCDNAppListConfig:(NSDictionary*)config;
-(void)setCCDNBlacklistAppConfig:(NSDictionary*)config;
-(void)setCCDNAppSwitch:(NSDictionary*)config;
//ccdn MISC config
-(void)setMISCDumpConfig:(NSDictionary*)config;

-(BOOL)enableSessionCache;

//cache开关
+ (NSString *)getTheRealCCDNHandleUrl:(MASSTFSDownMethod*)method;
+ (BOOL)canCacheForMethod:(MASSTFSDownMethod*)method reason:(int*)reason;
+ (BOOL)canCacheForMethod:(NSString *)urlString
                  bizType:(NSString *)bizType
            externHeaders:(NSDictionary *)externHeaders
                   reason:(NSString **)reason;
+ (BOOL)enableH5CacheInSessionForURLString:(NSString *)urlString
                                    reason:(NSString **)reason;
+ (int)canUseSycQueryCacheWithAppId:(NSString *)appId;
//@property(nonatomic)int openCache;
+(BOOL)canUseCCDNAppId:(NSString*)appId;
+(BOOL)canUseCCDN:(NSString*)url appId:(NSString*)appId;
+(BOOL)canUseCCDN:(NSString*)url appId:(NSString*)appId type:(int)type;
+(BOOL)isCCDNAppUrl:(NSString*)url;
+(NSArray*)getWhiteListApps;

+(int)httpCacheVolume;
+(int)taCheckTime;
+(int)h5MemoryEntryMaxCount;
+(int)tappMemoryEntryMaxCount;
+(BOOL)supportSubPackage;
+(BOOL)persistNoStoreWhenPrePush;
+(BOOL)enableValidateOffset;
+(BOOL)enableValidateFileLength;
+(BOOL)enableFillContentLength;

//prePush
-(void)updataPrePushUrlsMap:(NSDictionary*)dic;
-(BOOL)urlInPrePush:(NSString*)url;
-(NSDictionary*)prePushUrls;
@end
