//
//  MASSMethod.h
//  MASSProxy
//
//  Created by cuinacai on 16/2/24.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MASSMethod.h"
#import "MASSProxyDefine.h"
#import <MASSChannel/NBNetDownloadCommon.h>

typedef NS_ENUM(NSUInteger, MASSCachePolicy)
{
    MASSCachePolicyDefault = 0,//默认缓存逻辑，先查缓存
    MASSCachePolicyIgnoringLocalCache,//只请求网络数据，忽略不适用缓存
    MASSCachePolicyOnlyLocalCache//只用本地缓存，没有就返回空，不做网络请求
};

typedef NS_ENUM(NSInteger, MASSHTTPCacheStatus)
{
    MASSHTTPCacheStatusSucc = 0,//读到缓存没有错误，并且已经回调
    MASSHTTPCacheStatusNoCache,//无缓存
    MASSHTTPCacheStatusFail,//读取错误,cacheRusult==nil效果一样
    MASSHTTPCacheStatusExpired,  //过期
};

typedef NS_ENUM(NSInteger, MASSTFSRequestCallbackThreadType)
{
    MASSTFSRequestCallbackThreadTypeDefault = 0,    //默认线程
    MASSTFSRequestCallbackThreadTypeResidentThread, //指定常驻线程
};


@class APCacheRequest, APCachedResponse;
typedef BOOL (^mass_write_ccdn_intercept_block_t)(NSInteger httpStatusCode, APCacheRequest * _Nonnull cacheRequest, APCachedResponse * _Nonnull cacheResponse);

@interface MASSDownBaseMethod : MASSMethod
@property(nonatomic)MASSDownReturnType downReturnType;      //返回文件还是内存
@property(nonatomic, strong) NSString *saveFilePath;        //返回的如果是文件，保存的绝对路径
@property(nonatomic, strong) NSData* mmdpBizParam;          //mmdp协议业务协议数据
@property(nonatomic, assign) BOOL   backgroundTask;         //是否是后台自动触发，比如一些预推资源
@property(nonatomic, strong) NSString* expectMd5;           //最后校验的md5
@property(nonatomic,assign) NSTimeInterval  toMASSTime;     //任务到达MASS时间，给后台任务专门使用，其他任务不需要使用
@property(nonatomic,assign) BOOL   radical;               //紧急任务，需要做激进处理
@end


@interface MASSDownMethod : MASSDownBaseMethod
@property(nonatomic, strong) NSString *fileId;              //文件ID
@property(nonatomic, assign) BOOL isPicture;                //是否是图片下载
@property(nonatomic, strong) NSString *zoom;                //对应django协议的zoom参数
@property(nonatomic) BOOL isGradual;                        //是否需要渐显
@property(nonatomic, strong) NSDictionary* extraUrlParams;  //额外要填的url参数
@property(nonatomic, strong) NSDictionary<NSString*,NSString*>* extralMMDPParams;
@end

@interface MASSTFSDownMethod : MASSDownBaseMethod
@property(nonatomic, strong) NSString *url;                 //资源的url
@property(nonatomic, strong) NSDictionary* externHeaders;   //私有头
@property(nonatomic) BOOL   otherUrl;                       //非图片下载的一些扩展，主要是给ATS审核使用
@property(nonatomic) BOOL   isGradual;                      //是否需要渐显
@property(nonatomic) BOOL   isPost;                         //是否是post请求
@property(nonatomic) NSData*    postBody;                   //post请求的body
@property(nonatomic) BOOL   needContinueLoad;               //该资源下载是文件下载的情况下，是否要支持续传，主要给边下边播使用
@property(nonatomic) BOOL   NBNetDownload;                  //新数据通道的下载，将fileid拼接成蚂蚁cdn下载的url后进行的下载
@property(nonatomic) BOOL   ignore30X;                      //30x就直接返回失败
@property(nonatomic) NSTimeInterval waitTimeout;//队列中等待时间，填0或者不填位默认时间
@property(nonatomic) MASSCachePolicy massCachePolicy;//默认值MASSCachePolicyDefault
@property(nonatomic) BOOL urgentFlag;//目前主要埋点使用，默认NO
@property(nonatomic) BOOL isMainDocumentRequest;//该请求是不是主文档请求
@property(nonatomic) BOOL isChangeAyncThreadWhenCacheExist;//如果缓存存在是否需要切线程，默认切
//回调线程的类型，默认是MASSTFSRequestCallbackThreadTypeDefault
@property(nonatomic) MASSTFSRequestCallbackThreadType callbackThreadType;
//callbackThread是回调时候的线程，该值为空的话可能会使用网络这边的线程（注意：callbackThread一定要是常驻线程）
//callbackThreadType == MASSRequestCallbackThreadTypeResidentThread时候用
@property (atomic, strong) NSThread * _Nullable callbackThread;
//modes是callbackThread对应的mode，modes空（nil或者空数组）时候会使用NSDefaultRunLoopMode
@property (atomic, copy) NSArray * _Nullable modes;
/**
 * 添加请求一条Tag
 *
 * @param value
 *            请求Tag value
 * @param key
 *            请求Tag name
 */
-(void)addTags:(NSString*)value forKey:(NSString*)key;

@end



@interface MASSTFSDownMethod(CCDN)
@property(nonatomic) BOOL disableCache;
//查询ccdn缓存时，前置检查是否忽略If-Modified-Since/If-None-Match头，如果为NO，则不会查询ccdn，直接发起网络请求
@property(nonatomic) BOOL ccdnQueryIgnore304;
@property(nonatomic) BOOL forceQueryCCDN; // 强制查询ccdn，这个开关的优先级会高于其他
@property(nonatomic) BOOL noIntercept;
@property(nonatomic, copy) NSString *ccdnReqEtag;
@property(nonatomic, copy) NSString *ccdnReqLastModified;
@property(nonatomic,strong) NSMutableDictionary<NSString*,NSString*> *innerExternInfo;
@property(nonatomic,strong) NSMutableDictionary<NSString*,NSString*> *innerExternOutInfo;
@property (nonatomic) BOOL prePushRes;
@property (nonatomic) long long absExpireTime;
@property (nonatomic,strong)NSString *appid4Ccdn;
@property (nonatomic) BOOL tryStreamProgress;//isGradual=YES&非POST&DTN时候生效
@property (nonatomic) BOOL streamProgress;
@property(nonatomic) BOOL ccdnForceCacheExpired; // 如果ccdn缓存存在，强制缓存过期，发起304请求
@property(nonatomic, copy) mass_write_ccdn_intercept_block_t interceptWriteCCDNBlock;   //拦截header or body，可以做一些特殊的处理，当返回YES时，则会忽略整个写ccdn
@property(nonatomic, assign) MASSHTTPCacheStatus cacheStatus; // 标识当前的资源是否命中ccdn缓存
@property(nonatomic)BOOL needCbThread;//是否需要切线程，内部使用
@end


@interface MASSURLDownMethod : MASSDownBaseMethod
@property(nonatomic,strong) NSString* url;              //url
@property(nonatomic,assign) BOOL isGradual;                  //是否需要渐显
@property(nonatomic,strong) NSDictionary* externHeaders;    //私有请求头
@property(nonatomic,assign) BOOL ignore30x;                 //30x就直接返回失败
@property(nonatomic) MASSCachePolicy massCachePolicy;//默认值MASSCachePolicyDefault
@end

@interface MASSMarkDownMethod : MASSDownBaseMethod
@property(nonatomic, strong) NSString *fileId;              //主图的文件ID
@property(nonatomic, strong) NSString *zoom;                //主图的zoom
@property(nonatomic, strong) NSDictionary<NSString*,NSString*>* extralMMDPParams;
@end
