//
//  MASSMiscUtils.h
//  MASSChannel
//
//  Created by cuinacai on 2021/2/3.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MASSMiscUtils : NSObject
/**
 *  gw域名转http为https
 *  @param url 转化的url
 *  @param transform 是否转化成功
 *  @return 结果
 */
+(NSString*)gwHttpTransform2Https:(NSString*)url transform:(BOOL*)transform;
/**
 *  域名收敛
 *  @param url 收敛的url
 *  @param transform 是否转化成功
 *  @return 结果
 */
+(NSString*)transformRequestUrl:(NSString *)url transform:(BOOL*)transform;
/**
 将url转换到高保障url下，如果url和业务标志支持，则h返回对应的高保障url，否则则返回原始传入的url
 (实际调用)[APMHighAvailabilityProcessor highAvailabilityUrlForUrl:bizType:isPicture:]
 @param urlStr 需要转换的url，
 @param bizType 业务标志
 @return 如果url和业务标志支持，则h返回对应的高保障url，否则则返回原始传入的url
 */
+(NSArray *)highAvailabilityUrlForUrl:(NSString *)urlStr bizType:(NSString *)bizType;
@end

