//
//  MASSConfigCenter.h
//  MASSChannel
//
//  Created by yangxiao on 15/11/25.
//  Copyright © 2015年 ppp. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <APBaseInterfaceAdapter/APBaseInterfaceAdapter.h>

#define RTT_TIMEOUT_CONF_KEY @"toc"     //超时默认10s
#define RTT_TIMEOUT_2G @"to2g"
#define RTT_TIMEOUT_3G @"to3g"
#define RTT_TIMEOUT_4G @"to4g"
#define RTT_TIMEOUT_WIFI @"towi"
#define RTT_TIMEOUT_DEFAULT @"todft"

#define RTT_TIMEOUT_EMERGENCY_KEY @"emgc_toc"

#define UNIT_SIZE_CONF_KEY @"uzk"       //任务大小默认100k
#define UNIT_SIZE_2G @"u2g"
#define UNIT_SIZE_3G @"u3g"
#define UNIT_SIZE_4G @"u4g"
#define UNIT_SIZE_WIFI @"uwi"
#define UNIT_SIZE_DEFAULT @"udft"
#define PIECE_SIZE_CONF_KEY @"pzk"      //分片大小默认 10k
#define PIECE_SIZE_2G @"p2g"
#define PIECE_SIZE_3G @"p3g"
#define PIECE_SIZE_4G @"p4g"
#define PIECE_SIZE_WIFI @"pwi"
#define PIECE_SIZE_DEFAULT @"pdft"
#define DOWNLOAD_TASK_CUNCURENT @"dlc"
#define TFS_DOWNLOAD_TASK_CUNCURENT @"tfsc"
#define TFS_CAN_CRYPTO_HOSTS @"tfsch"
#define USING_CHUNK_LOGIC @"ucl"
#define USING_URL_ENCODE_LOGIC @"uuel"
#define TFS_USING_URL_ENCODE_LOGIC @"tuul"
#define MAX_CUNCURRENT_LINK_COUNT @"mclc"
#define DELTA_PERCENT_PARTLY_IMG_SHOW @"dltp"
#define NBNET_FREQUENCE_CONNECT_SWITCH @"nfcs"
#define USING_NEW_RUNLOOP_FUNC @"unrf"
#define NETSERVICE_UPERR_REPORT @"massup"

//从这条开始配置值就是存储值
#define BIZ_NOT_USE_MASS @"bnum"
#define TFS_COOKIE_SWITCH @"tcs"
#define LOW_PRIORITY_LIST @"lpl"
#define LOW_PRIORITY_HOST @"lph"
#define LOW_PRIORITY_BIZ @"lpb"
#define TFS_USE_GZIP @"tzip"
#define RECORDING_USE_FILE_UPLOAD @"rufu"
#define TFS_USE_DNS_BEFORE @"tudb"
#define BIZ_ID_USE_DJANGO @"biud"
#define ABROAD_USE_MMDP @"aumd"
#define ABROAD_USE_MMUP @"aumu"
#define BACK_GROUD_FETCH_TOKEN @"bgft"
#define BACK_GROUND_DOWNLOAD @"bgd"
#define TIMEOUT_ERROR_CLASSFY @"tec"
#define FLOW_STATIS_KEY @"fsk"
#define MD5_CHECK_SWITCH @"mcs"
#define EXECUTE_NBTASK_NONE_NET @"ennn"
// cdn续传逻辑开关
#define CONTINUS_CDN_SWITCH @"ccs"
#define CONTINUS_SERVICE_LIST @"csl"

#define USE_MMDP_DIRECT_BIZS @"umdb"

#define BACK_GROUND_FETCH_CAN_DOWNLOAD @"bfd"

#define SAFE_CDN_SWITCH @"scsw"
#define SAFE_CDN_WAIT_SECONDS @"scws"

#define MMTP_TO_HTTP @"mth"
#define MMTP_HTTP_CRYPTO @"mhc"

#define CAN_BACKGROUND_DOWNLOAD_BIZS @"cbdb"

#define MASS_CDN_HOST @"mch"

#define ID_TO_URL_USE_MDN @"itum"

#define TFS_HOST_IP_LIST_CACHE_TIME 10

#define GW_CONVERT_SWITCH @"gcs"

#define DJANGO_DOWNLOAD_HOST_CONVERT @"ddhc"

#define FID_TO_URL_NEW_SWITCH @"funs"

#define UPLOAD_USE_DTN @"uud"

#define FID_TO_URL_MASS @"ftum"

#define MDN_UNUSE_GW @"mug"

#define CCDN_PRE_TEST_SWITCH @"cpts"

#define MASS_API_SERVER_HOST @"api-mayi.django.t.taobao.com"
#define MASS_UP_SERVER_HOST @"up-mayi.django.t.taobao.com"
#define MASS_DOWN_SERVER_HOST @"oalipay-dl-django.alicdn.com"
#define MASS_DOWN_SERVER_HOST_OLD @"alipay.dl.django.t.taobao.com"
#define MASS_GW_HOST @"mass.alipay.com"
#define MASS_GW_HOST_OLD @"mdgw.alipay.com"

@interface ServerAddressInfo : NSObject

@property (nonatomic) NSString* ip;
@property (nonatomic) NSInteger port;

@end

//由于次tfs域名查询是需要查文件的，所以减少频率，在一段时间用这里的缓存
@interface TfsIpListInfo : NSObject
@property (nonatomic) NSMutableArray<NSString*>*    ipList;
@property (nonatomic) NSInteger                     timeoutTime;
/**
 *  构造
 *
 *  @param list
 *  @param t
 *
 *  @return
 */
+(instancetype)TfsIplistInfoWithIplist:(NSMutableArray<NSString*>*)list TimeoutTime:(NSInteger)t;
@end

@interface FlowStatisticInfo : NSObject

@property (nonatomic,assign) NSInteger  tcpCount;

@property (nonatomic,assign) NSInteger  sslCount;

@property (nonatomic,assign) NSInteger  upFlow;

@property (nonatomic,assign) NSInteger  downFlow;

@property (nonatomic,assign) NetAccessType netType;

@end

@interface DTNConfigItem : NSObject
//DTN
@property (nonatomic, assign) BOOL                  dtnSwitch;
//DTN QUIC
//@property (atomic, strong) NSString                 *quicSwitch;
@property (atomic) BOOL                             ccdnPPushClose;//ccdn预推支持quic开关
@property (atomic, strong) NSDictionary             *quicSupport;
@property (atomic, strong) NSArray                  *quicOnly;
@property (atomic, strong) NSDictionary             *tranUrl;
@property (nonatomic,) int                          quicMode;
@property (atomic, strong) NSArray                  *quicPathPrefixList;
@property (atomic, strong) NSArray                  *quicPathSuffixList;
@property (atomic, strong) NSDictionary             *quicBizMap;
@property (atomic, strong) NSArray                  *quicBizPrefixList;
@property (atomic, strong) NSArray                  *quicBlackBizs;
//http2
@property (atomic, strong) NSDictionary             *h2Support;
//H5
@property (nonatomic,) int                          mode;
@property (atomic, strong) NSDictionary             *h5HostsMap;
@property (atomic, strong) NSArray                  *h5PathPrefixList;
@property (atomic, strong) NSArray                  *h5PathSuffixList;
@property (atomic, strong) NSDictionary             *h5BizMap;
@property (atomic, strong) NSArray                  *h5BizPrefixList;
//session H5
@property (nonatomic,) int                          sMode;
@property (atomic, strong) NSDictionary             *sH5HostsMap;
@property (atomic, strong) NSArray                  *sH5PathPrefixList;
@property (atomic, strong) NSArray                  *sH5PathSuffixList;
@property (atomic, strong) NSDictionary             *sH5BizMap;
@property (atomic, strong) NSArray                  *sH5BizPrefixList;
//log
@property (atomic, strong) NSDictionary             *logHostsMap;
@property (atomic, strong) NSDictionary             *logBizMap;
@property (atomic, strong) NSArray                  *logBizPrefixList;
@property (atomic, strong) NSArray                  *logBlackBizs;
//H5 blacklist
@property (atomic, strong) NSArray                  *h5HostBlacklist;
@property (atomic, strong) NSArray                  *h5PathPrefixBlacklist;
@property (atomic, strong) NSArray                  *h5PathSuffixBlacklist;
//DTN shadow
@property (nonatomic, assign) int                   timesPerHour;    //DTN
@property (atomic, strong) NSDictionary             *shadowHostsMap;    //DTN
//CCDN 走 DTN
@property (atomic, strong) NSDictionary             *ccdnDTNMap;
@property (nonatomic, assign) BOOL                  downgradeSwitch;
@property (nonatomic, assign) int                   downgradeMaxErrCount;
@property (atomic, strong) NSString                 *dtnGroup;
//DTN 埋点抽样，默认关闭
@property (nonatomic, assign) BOOL                  perfNotSampling;
@property (nonatomic, assign) BOOL                  useDTNQueue;
@property (nonatomic, assign) int                   maxDTNQueueCount;
@property (nonatomic, assign) int                   maxDTNRequestCount;
@property (nonatomic, assign) int                   maxSessDTNReqCount;
//预建连开关
@property (nonatomic, assign) BOOL                  preConnection;
//启动预建连开关
@property (nonatomic, assign) BOOL                  preconnectionWhenInit;

//适配HTTP错误码，默认关闭
@property (nonatomic, assign) BOOL                  adaptStatusCode;
//适配HTTP错误码204,默认开
@property (nonatomic, assign) BOOL                  adaptStatus204;
//Accept-Encoding替换为gzip
@property (nonatomic, assign) BOOL                  adaptAEGzip;
@property (nonatomic, assign) BOOL                  forceGzip;
@property (nonatomic, assign) BOOL                  convergenceURL;
//不可用功能开关
@property (nonatomic, assign) BOOL                  unavailableSwitch;
//progress回调包大小开关
@property (nonatomic, assign) BOOL                  rspSizeCtrl;
//最大次数
@property (nonatomic, assign) int                   maxErrTimes;
//这个时间内（单位为秒）
@property (nonatomic, assign) int                   maxTimeIntervalSec;
//埋点队列开启
@property (nonatomic, assign) BOOL                  mdapQueue;
//队列并发个数，默认最大20
@property (nonatomic, assign) int                   maxMdapQueueCount;
//dtn session Switch
@property (nonatomic, assign) BOOL                  sessionSwitch;
//DTN2走Session三方灰度开关
@property (atomic, strong) NSString                 *protocolThird;
@property (atomic, strong) NSArray                  *h1AppidThird;
@property (atomic, strong) NSArray                  *h12AppidThird;
@property (atomic, strong) NSArray                  *h123AppidThird;
@property (atomic, strong) NSDictionary             *appidThird;
@property (atomic, strong) NSDictionary             *happidThird;
@property (atomic, strong) NSString                 *route;
@property (atomic, strong) NSArray                  *hostsThird;
@property (atomic, strong) NSArray                  *blackHostThird;
@property (atomic,strong)  NSArray                  *saveTicketBlacklist;
@property (nonatomic,assign)  BOOL                  jsAllowThird;
@property (nonatomic,assign)  BOOL                  saveThirdTick;
//国密总开关
@property (atomic,assign) BOOL                      enableGmCaSwitch;
//国密证书List
@property (atomic,strong)  NSArray                  *enableGmHostList;
@property (atomic,assign) BOOL                      rspCfFix;
@property (nonatomic,assign) BOOL                   closeBizDtnH2;
@property (nonatomic,assign) BOOL                   checkCbAnr;//检查回调ANR
@property (nonatomic,assign) BOOL                   cbBizThread;//检查回调ANR
@property (atomic,assign)  BOOL                     dataToQosSwitch;//数据通道数据是否调用到qos模型
@property (atomic, strong) NSString                 *dtnDmConverge;//收敛的总开关，默认关闭
@property (atomic, strong) NSString                 *dtnGwforcehttps;//强制https的开关，默认开启
@property (atomic, strong) NSString                 *dtnCdnConverge;//cdn收敛的开关，默认开启
@property (atomic, strong) NSString                 *adkl;//高可用开关域名关键子开关，默认为"alipay,alicdn"
//mdn收敛开关，默认开启，到DTN层转为"dtn_mdnconverge"，例子:"dtn_mdnconverge":"1"
@property (atomic, strong) NSString                 *dtnMdnconverge;
//到DTN层转为"dtn_mdnconverge_target"，例子："dtn_mdnconverge_target":"mdn.alipayobjects.com"
@property (atomic, strong) NSString                 *dtnMdnconvergeTarget;
//例子："dtn_mdnconverge_hosts":"zos.alipayobjects.com/mwalletmngappcenter,zos.alipayobjects.com/promocreative"
@property (atomic, strong) NSString                 *dtnMdnconvergeHosts;
@property (atomic, strong) NSString                 *dtnNoBodyFix;//304带content-length情况开关
@property (atomic, strong) NSString                 *dtnMultiHeadFix;//处理QUIC头重复时候情况开关（关闭连接，重试任务）
@property (atomic, strong) NSString                 *dtnRenderAliveTime; //表示render.alipay.com在h2h3情况的保活时长，单位是秒
@property (atomic, strong) NSString                 *dtnSessionAliveTime;//"10,20"
@property (atomic, strong) NSString                 *reqRetryTime;//默认空值""，第一个值是内部域名的时间，第二值是三方的时间，单位秒
//"render.aplay.com,render2.aplay.com",默认空值"",支持0RTT的域名（域名级别控制0rtt），和dtn_tlsv1_3_0rtt是或的关系
@property (atomic, strong) NSString                 *hosts0Rtt;
@property (atomic, strong) NSString                 *checkThreadIdle;
@property (atomic, strong) NSString                 *retSslError;
@property (atomic, strong) NSString                 *checkCdnDownStatus;
@property (atomic, strong) NSString                 *fastCleanThread;
@property (atomic, strong) NSDictionary             *dg;//dtn gray
@property (atomic, strong) NSDictionary             *dv;//dtn value

-(BOOL)isAlipayHost:(NSString*)host;
@end

@interface MASSConfigCenter : NSObject

@property (nonatomic) NetAccessType             netType;                        //网络类型

@property (atomic) NSMutableDictionary*      rttTimeOutConf;                 //一个网络来回的超时时间设置

@property (atomic) NSMutableDictionary*      rttTimeOutConfEmgc;                 //一个网络来回的超时时间设置(激进)

@property (nonatomic) NSString*                 registHostUp;                   //上传的域名

@property (nonatomic) NSMutableArray*           upIpList;                       //上传的服务端地址列表

@property (nonatomic) NSString*                 registHostDown;                 //下载的域名

@property (nonatomic) NSMutableArray*           downIpList;                     //下载的服务端地址列表

@property (nonatomic) NSString*                 registHostDownCrypto;           //加密下载需要跟换域名的

@property (nonatomic) NSMutableArray*           downIplistCrypto;               //加密下载的ip列表

@property (nonatomic) NSString*                 registTokenHost;                //指令服务域名

@property (nonatomic) NSMutableArray*           tokenIpList;                    //指令服务地址列表

@property (atomic) NSMutableDictionary*      dataPiceUnitSize;               //数据最小分片大小

@property (atomic) NSMutableDictionary*      dataPartUnitSize;               //任务分片大小

@property (nonatomic) float                     tokenRequestInternal;           //请求token的时间间隔

@property (nonatomic) float                 deltaPercentPartlyImgShow;      //渐显的最小百分比

@property (nonatomic) NSInteger                 downloadTasksSameTime;          //能同时进行的下载数量

@property (nonatomic) NSInteger                 lastTfsFailCount;          //连续失败次数记录

@property (nonatomic) NSInteger                 tfsDownloadTasksSameTime;       //能同时进行的tfs下载数量

@property (nonatomic) id<NetAccessInfo>         tfsHostInfoInterface;           //提供域名查询iplist接口

@property (nonatomic) NSMutableSet<NSString*>*  tfsCanCryptoHosts;              //tfs下载的时候能降级的域名

@property (nonatomic) BOOL                      usingChunkLogic;                //tfs是否处理chunked回包

@property (nonatomic) BOOL                      djangoUsingUrlEncodeLogic;            //对dj url是否需要进行特殊字符编码

@property (nonatomic) BOOL                      tfsUsingUrlEncodeLogic;                 //对tfs url是否需要进行特殊字符编码

@property (nonatomic) BOOL                      useNewRunloopFunc;                      //是否使用阻塞式runloop

@property (nonatomic) NSMutableArray*           bizNotUseMASS;                          //哪些业务不用MASS通道，用苹果通道

@property (nonatomic) NSInteger                 safeCdnStartSeconds;            //等待多久后会开启主站高保障

@property (nonatomic) BOOL                      tfsUseCookieManager;                    //是否管理cookie的开关

@property (atomic) NSArray*                  lowPriorityHosts;                       //tfs请求中低优先级的域名列表

@property (atomic) NSArray*                  lowPriorityBiztypes;                    //tfs请求中优先级低的业务列表

@property (nonatomic,assign) BOOL               tfsUseGzip;                             //url下载是否需要使用gzip回包压缩

@property (nonatomic,assign) BOOL               recordingUseFileUpload;                 //边录边传直接使用文件上传

@property (nonatomic,assign) BOOL               tfsUseDnsBefore;                        //在进行url资源下载时，先做dns解析

@property (nonatomic,assign) BOOL               massUpErrReport;                        //上传不可用上报开关

@property (nonatomic) NSArray*    bizIdUseDjangoEnforce;                  //buzid的开关，没有值表示不需要,如果bizid在列表中，这个业务强制走改良版

@property (nonatomic,assign) BOOL               abroadUseMMDP;              //海外用户是否用mmdp

@property (nonatomic,assign) BOOL               abroadUseMMUP;              //海外用户是否用mmup

@property (nonatomic,assign) BOOL               backGroudTokenGet;          //是否在后台刷token

@property (nonatomic,assign) BOOL               downloadBackground;         //是否开启后台下载功能

@property (nonatomic,assign) BOOL               errorTimeoutClassfy;               //是否做错误细分

@property (nonatomic,assign) BOOL               flowStatisticSwitch;                //是否做流量统计的开关

@property (nonatomic,assign) BOOL               continusSwitch;                     //是否开启cdn跨任务续传

@property (atomic,strong) NSArray*              continusServiceList;                //支持续传的域名列表，是支持类似 *.alipay.com 这种通配的

@property (atomic,strong) NSArray*              mmdpDirectBizs;                     //对于这些业务，必须打开mmdp开关

@property (nonatomic, assign) BOOL              needCheckMd5;                       //是否检查md5的总开关

@property (nonatomic, assign) BOOL              needNoNetExecute;                   //无网络的情况下是否需要执行任务

@property (nonatomic, assign) BOOL              backGroundFetchCanDownload;         //background fetch下能否下载

@property (nonatomic, assign) BOOL              safeCdnSwitch;                      //cdn高保障总开关

@property (nonatomic, assign) NSUInteger        safeCdnLastFailTime;                //cdn高保障这次失败后，要等一段时间才能进行下次的尝试

@property (nonatomic, assign) BOOL              mmdpToHttp;                         //mmdp转http开关
@property (nonatomic, assign) BOOL              mmdpHttpCrypto;                     //mmdp转http是https还是http

//@property (nonatomic) NSMutableArray*           bizDealCookies;                         //哪些业务需要管理cookie

@property (atomic, strong) NSArray*   backdownloadBizs;               //哪些业务可以后台下载

@property (atomic, strong) NSString*  massCDNHost;                      //mdn域名

@property (nonatomic, assign) BOOL              idToUrlUseMass;
@property (atomic, strong) NSDictionary *ccdnConfig;
@property (atomic) BOOL xmchSwitch;
@property (atomic) BOOL preConnSwitch;//urlSession预建连兜底开关，默认开
@property (atomic) BOOL gwForceHttps;
@property (atomic) BOOL contentLengthZero;//post body为空时候是否设置content-length=0，默认为NO
@property (atomic) BOOL appendPort;//是否添加端口，默认为NO

@property (nonatomic, strong) NSString*             gwHostMASS;         // mass.alipay.com
@property (nonatomic, strong) NSString*             gwHostOld;          // mdgw.alipay.com
@property (nonatomic, assign) BOOL                  gwConvertSwitch;    // 老网关换成新网关的开关

@property (nonatomic, assign) BOOL                  djangoDownloadHostSwitch;       // django的CDN替换成mdn的开关

@property (nonatomic, assign) BOOL                  fileIDNewLogicSwitch;       // fileid转url新逻辑，去掉django

@property (nonatomic, assign) BOOL                  uploadUsingDTN;             // 上传用dtn的控制

@property (nonatomic, assign) BOOL                  privateFileidToUrlUseMass;         // fileid转url使用mass协议的开关

@property (nonatomic, assign) BOOL                  mdnNotUseGw;        //mdn url不使用gw收敛规则

@property (nonatomic, assign) BOOL                  ccdnPreTestOpen;    //开启预推演练的开关

//DTN
//@property (nonatomic, assign) BOOL                  dtnSwitch;
////DTN QUIC
@property (atomic, strong) NSString                 *quicSwitch;
//@property (atomic) BOOL                             ccdnPPushClose;//ccdn预推支持quic开关
//@property (atomic, strong) NSDictionary             *quicSupport;
//@property (atomic, strong) NSArray                  *quicOnly;
//@property (atomic, strong) NSDictionary             *tranUrl;
@property (atomic, strong) NSString                 *quic0RttEnable;
@property (atomic, strong) NSString                 *quiclb;
@property (atomic, strong) NSString                 *channelSelect;
//@property (nonatomic,) int                          quicMode;
//@property (atomic, strong) NSArray                  *quicPathPrefixList;
//@property (atomic, strong) NSArray                  *quicPathSuffixList;
//@property (atomic, strong) NSDictionary             *quicBizMap;
//@property (atomic, strong) NSArray                  *quicBizPrefixList;
//H5
//@property (nonatomic,) int                          mode;
//@property (atomic, strong) NSDictionary             *h5HostsMap;
//@property (atomic, strong) NSArray                  *h5PathPrefixList;
//@property (atomic, strong) NSArray                  *h5PathSuffixList;
//@property (atomic, strong) NSDictionary             *h5BizMap;
//@property (atomic, strong) NSArray                  *h5BizPrefixList;
//log
//@property (atomic, strong) NSDictionary             *logHostsMap;
//@property (atomic, strong) NSDictionary             *logBizMap;
//@property (atomic, strong) NSArray                  *logBizPrefixList;
//@property (atomic, strong) NSArray                  *logBlackBizs;
//H5 blacklist
//@property (atomic, strong) NSArray                  *h5HostBlacklist;
//@property (atomic, strong) NSArray                  *h5PathPrefixBlacklist;
//@property (atomic, strong) NSArray                  *h5PathSuffixBlacklist;
//DTN shadow
//@property (nonatomic, assign) int                   timesPerHour;    //DTN
//@property (atomic, strong) NSDictionary             *shadowHostsMap;    //DTN
//CCDN 走 DTN
//@property (atomic, strong) NSDictionary             *ccdnDTNMap;
//@property (nonatomic, assign) BOOL                  downgradeSwitch;
//@property (nonatomic, assign) int                   downgradeMaxErrCount;
//DTN SOS
@property (atomic, strong) NSString                 *dtnSos;
//@property (atomic, strong) NSString                 *dtnGroup;
//DTN 埋点抽样，默认关闭
//@property (nonatomic, assign) BOOL                  perfNotSampling;
//@property (nonatomic, assign) BOOL                  useDTNQueue;
//@property (nonatomic, assign) int                   maxDTNQueueCount;
//@property (nonatomic, assign) int                   maxDTNRequestCount;
//预建连开关
//@property (nonatomic, assign) BOOL                  preConnection;
//启动预建连开关
//@property (nonatomic, assign) BOOL                  preconnectionWhenInit;
//提高线程优先级开关
@property (atomic, strong) NSString                 *raiseThreadPriority;
//日志开关
@property (atomic, strong) NSString                 *printInfoLog;
//ip排序
@property (atomic, strong) NSString                 *useNetSource;
@property (atomic, strong) NSString                 *moreMainIp;
@property (atomic, strong) NSString                 *cleanIpv6;
@property (atomic, strong) NSString                 *enableTlsv1_3;
@property (atomic, strong) NSString                 *tlsv1_3_0rtt;
@property (atomic, strong) NSString                 *disableQuicRecord;
@property (atomic, strong) NSString                 *enableRange;
@property (atomic, strong) NSString                 *ignoreUnknownSsid;
@property (atomic, strong) NSString                 *reportLinkPerfLog;
@property (atomic, strong) NSString                 *systemCertVerify;
@property (atomic, strong) NSString                 *dtnLdnsFilter;
@property (atomic, strong) NSString                 *stayConnections;
@property (atomic, strong) NSString                 *netchangeOptim;
@property (atomic, strong) NSString                 *enableNetInfo;
//DTN队列开关
@property (atomic, strong) NSString                 *enableReqWaitQ;
@property (atomic, strong) NSString                 *reqExcMaxCount;
@property (nonatomic, assign) BOOL                  mUpThread;
@property (nonatomic, assign) BOOL                  upTimeMs;
//适配HTTP错误码，默认关闭
//@property (nonatomic, assign) BOOL                  adaptStatusCode;
////适配HTTP错误码204,默认开
//@property (nonatomic, assign) BOOL                  adaptStatus204;
////Accept-Encoding替换为gzip
//@property (nonatomic, assign) BOOL                  adaptAEGzip;
//@property (nonatomic, assign) BOOL                  forceGzip;
//@property (nonatomic, assign) BOOL                  convergenceURL;
////不可用功能开关
//@property (nonatomic, assign) BOOL                  unavailableSwitch;
////progress回调包大小开关
//@property (nonatomic, assign) BOOL                  rspSizeCtrl;
////最大次数
//@property (nonatomic, assign) int                   maxErrTimes;
////这个时间内（单位为秒）
//@property (nonatomic, assign) int                   maxTimeIntervalSec;

-(BOOL)getFreshSessionSwitch;

@property (nonatomic, strong)DTNConfigItem               *dtnItem;
@property (nonatomic, strong)DTNConfigItem               *dtn2Item;
+(DTNConfigItem*)dtnConfigItem;
+(DTNConfigItem*)dtn2ConfigItem;
/**
 *  单例
 *
 *  @return
 */
+(instancetype)shareInstance;

/**
 *  初始化
 */
-(void)initFromFileStorage;

/**
 *  获取分片大小
 *
 *  @return
 */
-(NSUInteger)getPiceUnitSize;

/**
 *  获取分任务大小
 *
 *  @return
 */
-(NSUInteger)getPartUnitSize;

/**
 *  获取ip
 *
 *  @param retrys
 *
 *  @return
 */
-(NSString*)getUploadSvrIpRetrytimes:(NSUInteger)retrys;

/**
 *  获取ip
 *
 *  @param retrys
 *
 *  @return
 */
-(NSString*)getDownloadSvrIpRetrytimes:(NSUInteger)retrys;

/**
 *  获取ip
 *
 *  @param retrys
 *
 *  @return
 */
-(NSString*)getDownloadSvrIpCryptoRetrytimes:(NSUInteger)retrys;

/**
 *  获取ip
 *
 *  @param retrys
 *
 *  @return
 */
-(NSString*)getTokenSvrIpRetrytimes:(NSUInteger)retrys;

/**
 *  获取ip
 *
 *  @param retrys
 *
 *  @return
 */
-(NSString*)getTfsDownloadSvrIp:(NSString*)host retryTimes:(NSUInteger)retrys succ:(BOOL*)succ ipv6:(BOOL*)ipv6 canUseIPv6:(BOOL)canUseIPv6;
/**
 *  tfs Download Task Fail
 *
 *  @return
 */
-(void)tfsDownloadTaskFail;
/**
 *  建连超时
 *
 *  @return
 */
-(float)getConnectTimeout;

/**
 *  回包超时
 *
 *  @return
 */
-(float)getRspTimeout;

-(float)getRttTimeoutEmergency;

/**
 *  刷配置
 *
 *  @param conf
 */
-(void)freshConfig:(NSDictionary*)conf;

/**
 *  打日志用
 *
 *  @return
 */
-(NSString*)toString;

/**
 *  tfs
 *
 *  @param hosts
 */
-(void)setTfsCryptoHosts:(NSArray*)hosts;

/**
 *  tfs是否可以降级tls
 *
 *  @param host
 *
 *  @return 
 */
-(BOOL)canCryptoOnHost:(NSString*)host;

-(BOOL)isBizNotUseMASS:(NSString*)biz;

-(BOOL)isLowPriorityWithHost:(NSString*)host andBiz:(NSString*)biz;

//该业务是否禁止走新通道
-(BOOL)bizIdEnforceDjango:(NSString*)biz;

//该域名是否支持续传
-(BOOL)hostCanContinus:(NSString*)host;

// 某些业务要直接使用mmdp协议
-(BOOL)bizUseMMDPDirect:(NSString*)biz;

//可以后台下载的e业务
-(BOOL)bizCanBackgroundDownlaod:(NSString*)biz;

//刷新DTN配置
-(void)freshDTNConfig:(NSDictionary*)conf;
//刷新DTN2配置
-(void)freshDTN2Config:(NSDictionary*)conf;
@end
