//
//  FLSpider.h
//  FullLinkTracker
//
//  Created by wuyang on 2019/3/7.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface FLSpider : NSObject

/**
 *  初始化Spider, bizName不能为空。
 *  !默认返回nil，需要白名单用户才可诊断
 *
 *  param: bizName 业务标识
 */
+ (instancetype)instanceWithBizName:(NSString *)bizName;

/**
 *  初始化Spider, bizName不能为空。
 *  !业务不要轻易使用
 *
 *  param: bizName 业务标识
 */
- (instancetype)initWithSpiderBizName:(NSString *)bizName;

/**
 *  绑定clusterId，用于和全链路通信
 *
 *  param: clusterId 页面点位集ID
 */
- (void)bindFL:(NSString *)clusterId;

/*
 *  开始诊断
 */
- (void)startMonitor;

/*
 *  开始诊断，可业务自己传入开始时间
 *
 *  param: time 开始时间
 */
- (void)startMonitorWithTime:(CFTimeInterval)time;

/*
 *  结束诊断
 */
- (void)endMonitor;

/*
 *  结束诊断，可业务自己传入开始时间
 *
 *  param: time 开始时间
 */
- (void)endMonitorWithTime:(CFTimeInterval)time;

/*
 *  获取诊断数据
 *
 *  return jsonString
 */
- (NSString *)getReports;


// 未开放接口
- (void)startSectionMonitorWithSectionName:(NSString *)name;

- (void)startSectionMonitorWithSectionName:(NSString *)name
                                      time:(CFTimeInterval)time;

- (void)endSectionMonitorWithSectionName:(NSString *)name;

- (void)endSectionMonitorWithSectionName:(NSString *)name
                                    time:(CFTimeInterval)time;

- (void)addPropertyWithKey:(NSString *)key
                     value:(NSString *)value;

- (NSDictionary *)getPerformanceMap;

- (void)report;

@end

NS_ASSUME_NONNULL_END
