//
//  FLPerformanceDiagnoseHandler.h
//  FullLinkTracker
//
//  Created by shuoguang on 2019/3/7.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, FLPerformancePageEndType){
    FLPerformancePageEndTypeFramework = 1,
    FLPerformancePageEndTypeH5,
    FLPerformancePageEndTypeBiz
};

typedef NS_ENUM(NSUInteger, FLPerformanceCancelType){
    FLPerformanceCancelTypeEviction = 1
};


@interface FLPerformanceDiagnoseHandler : NSObject

@property (nonatomic, strong, readonly) NSString* key;

- (instancetype)initWithKey:(NSString*)key;

/**
 * 在发生 AppStart 时候回调
 *
 * @param clusterId 点位集 Id
 * @param time      事件发生的时间戳，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 */

- (void)onAppStart:(NSString*)clusterId time:(NSTimeInterval)time;

/**
 * 在发生 FrameworkFinished 时候回调
 *
 * @param clusterId 点位集 Id
 * @param time      事件发生的时间戳，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 */
- (void)onFrameworkFinished:(NSString*)clusterId time:(NSTimeInterval)time;

/**
 * 在发生 PageStart 时候回调
 *
 * @param clusterId 点位集 Id
 * @param time      事件发生的时间戳，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 */
- (void)onPageStart:(NSString*)clusterId time:(NSTimeInterval)time;

/**
 * 在发生 PageEnd 时候回调
 *
 * @param clusterId   点位集 Id
 * @param time        事件发生的时间戳，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 * @param type        页面结束类型
 */
- (void)onPageEnd:(NSString*)clusterId time:(NSTimeInterval)time type:(FLPerformancePageEndType)type;

/**
 * 在发生 logStub 回调
 *
 * @param clusterId 点位集 Id
 * @param key       点位 Key
 * @param time      事件发生的时间戳，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 */
- (void)onStub:(NSString*)clusterId key:(NSString*)key time:(NSTimeInterval)time;

/**
 * 在发生 logCost 时候回调
 *
 * @param clusterId 点位集 Id
 * @param key       点位 Key
 * @param time      耗时时长，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 */
- (void)onCost:(NSString*)clusterId key:(NSString*)key time:(NSTimeInterval)time;

/**
 * 在发生 logCostStart 时候回调
 *
 * @param clusterId 点位集 Id
 * @param key       点位 Key
 * @param time      事件发生的时间戳，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 */
- (void)onCostStart:(NSString*)clusterId key:(NSString*)key time:(NSTimeInterval)time;

/**
 * 在发生 logCostEnd 时候回调
 *
 * @param clusterId 点位集 Id
 * @param key       点位 Key
 * @param time      事件发生的时间戳，注意：底层使用的机器时间，单位是毫秒。CACurrentMediaTime() * 1000
 */
- (void)onCostEnd:(NSString*)clusterId key:(NSString*)key time:(NSTimeInterval)time;

/**
 * 在准备上报时候回调
 *
 * @param clusterId 点位集 Id
 * @return 诊断结果数据
 */
- (NSString*)onReport:(NSString*)clusterId;

/**
 * 取消诊断
 *
 * @param clusterId 点位集 Id
 * @param code      取消的原因
 */
- (void)onCancel:(NSString*)clusterId code:(FLPerformanceCancelType)code;

@end

