//
//  FLDiagnoseProtocol.h
//  FullLinkTracker
//
//  Created by wuyang on 2019/5/5.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol FLDiagnoseProtocol <NSObject>

@required

/**
 *  启动诊断
 */
- (void)start;

/**
 *  结束诊断
 */
- (void)end;

/**
 *  取消诊断
 */
- (void)cancel;

/**
 *  获取诊断结果
 */
- (NSDictionary *)getResult;

@optional

/**
 *  设置超时时间，若不设置则默认30s
 */
- (CFTimeInterval)timeOut;

@end

NS_ASSUME_NONNULL_END
